<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 discount models table
 * @property-read string $DIPO
 * @property-read string $TX08
 * @method static Builder byDiscModel($discModel)
 */
class OGDIPO extends Model {
    protected $table = "OGDIPO";

    const NUM_PRIORITY_LEVELS = 10; // PC1*, PC2*, PC3*, ..., PC9*, PC0*
    const NUM_PC_RULES = 5; // PC*1, PC*2, PC*3, etc

    /**
     * @param Builder $query
     * @param $discModel
     * @return Builder
     */
    public function scopeByDiscModel (Builder $query, $discModel): Builder {
        return $query->where('DISY', "=", "$discModel")->where("deleted", "=", 0);
    }

    /**
     * @return string
     */
    public function getBucketNo() {
        return $this->DIPO;
    }

    /**
     * @return string
     */
    public function getBucketName() {
        return $this->TX08;
    }

    /**
     * @param $rulesetNo
     * @param $ruleNo
     * @return string
     */
    public function getRule ($rulesetNo, $ruleNo): string {
        $pcCol = "PC$rulesetNo$ruleNo";
        return $this->$pcCol;
    }
}