<?php

namespace Hilco\Models;

class WebLink_WebSilo extends WebModel {

	protected $table = "WebLink_WebSilo";
    protected $fillable = ['weblink_id', 'websilo_id', 'plant_id', 'is_visible', 'display_name', 'link', 'type'];
    protected $with = ['webLink'];

    public function plant() {
        return $this->belongsTo(Plant::class, 'plant_id', 'id');
    }

    public function webLink() {
        return $this->belongsTo(WebLink::class, 'weblink_id', 'id');
    }

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function getUrl(){
        if ($this->type == 'landing_page') {
            $url = route('landingpage.slug', [$this->link]);
        } else if ($this->type == 'asset') {
            $url = config('hilco.assets.url');
            $url .= '/' . $this->link;
        } else {
            $url = url($this->link);
        }

        return $url;
    }

    public function getDisplayNameAttribute() {
        if (strlen($this->attributes['display_name'])) return $this->attributes['display_name'];

        return array_get($this, 'webLink.display_name');
    }

    public function getTypeAttribute() {
        if (strlen($this->attributes['type'])) return $this->attributes['type'];

        return array_get($this, 'webLink.type');
    }

    public function getLinkAttribute() {
        if (strlen($this->attributes['link'])) return $this->attributes['link'];

        return array_get($this, 'webLink.link');
    }
}
