<?php
/**
 * Created by PhpStorm.
 * User: jmartinez
 * Date: 5/8/2017
 * Time: 11:56 AM
 */

namespace Hilco\Models;


class PromotionRewardsTierTrigger extends PromotionTriggerDetails {
    protected $table = 'PromotionRewardsTierTriggers';

    public function setTierAttribute($tier) {
        $this->attributes['tier'] = $tier;
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = [])
    {
        $tierLevel = $soldToCustomer->rewardsTierLevel;
        return $tierLevel === $this->tier;
    }

    public function isTriggeredPostOrder(Order $order, $lineInfo)
    {
        return true;
    }

    public function postTriggerOperation($soldToCustomer)
    {
        // TODO: Implement postTriggerOperation() method.
    }
}