<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 4/6/18
 * Time: 12:01 PM
 */

namespace Hilco\Models;


class PromotionCodeTrigger extends PromotionTriggerDetails {

    protected $table = 'PromotionCodeTriggers';
    protected $fillable = ['code', 'commit_sequence'];

    public function promotion() {
        return $this->morphToMany(Promotion::class, 'trigger',
            'PromotionTriggers', 'trigger_id', 'promotion_id');
    }

    public function isTriggered(Customer $soldToCustomer, $webCartItems, $distinctPartInfo = []) {
        return $this->code === session()->get('b2b.activePromoCode');
    }

    public function isTriggeredPostOrder(Order $order, $lineInfo)
    {
        return true;
    }

    public function postTriggerOperation($soldToCustomer) {
        // TODO: Implement postTriggerOperation() method.
    }
}