<?php
/**
 * Created by PhpStorm.
 * User: ntaylor-visionware
 * Date: 11/15/17
 * Time: 7:11 PM
 */

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Class PromotionCustomerCategoryTrigger_CustomerCategory
 * @package Hilco\Models
 * @property integer $promotioncustomercategorytrigger_id
 * @property integer $customercategory_id
 * @property boolean $is_excluded
 */
class PromotionCustomerCategoryTrigger_CustomerCategory extends WebModel {
    protected $table = 'PromotionCustomerCategoryTrigger_CustomerCategory';
    protected $fillable = ['promotioncustomercategorytrigger_id', 'customercategory_id', 'is_excluded', 'commit_sequence'];

    public function promotionCustomerCategoryTrigger(): BelongsTo {
        return $this->belongsTo(PromotionCustomerCategoryTrigger::class,
                            'promotioncustomercategorytrigger_id', 'id');
    }

    public function customerCategory(): BelongsTo {
        return $this->belongsTo(CustomerCategory::class, 'customercategory_id', 'id');
    }

    public function scopeTriggerCustomerCategory($query, $trigger_id, $customerCategory_id) {
        return $query->where(
            [
                'promotioncustomercategorytrigger_id', $trigger_id,
                'customercategory_id', $customerCategory_id
            ]
        );
    }

    use HasCommitSequence;
}