<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Query\Builder;

/**
 * Hilco\Models\CustomerCategory
 *
 * @property mixed $id
 * @property string $cust_category
 * @property string $cust_category_desc
 * @property string $cust_cat_group
 * @property string $cust_cat_summary
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|Customer[] $customers
 * @property-read mixed $id_string
 * @method static Builder|CustomerCategory whereId($value)
 * @method static Builder|CustomerCategory whereCustCategory($value)
 * @method static Builder|CustomerCategory whereCustCategoryDesc($value)
 * @method static Builder|CustomerCategory whereCustCatGroup($value)
 * @method static Builder|CustomerCategory whereCustCatSummary($value)
 * @method static Builder|CustomerCategory whereDateCreated($value)
 * @method static Builder|CustomerCategory whereDateModified($value)
 * @method static Builder|CustomerCategory whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static Builder|CustomerCategory whereDateUploaded($value)
 */
class CustomerCategory extends WebModel {
	protected $table = 'CustomerCategories';

    protected static array $rewardsCategoriesStrs = [
        'OPHTHALMOLOGIST',
        'OPTICIAN',
        'OPTOMETRIST',
    ];

    /**
     * @return array|string[]
     */
    public static function getRewardsCategoriesStrs(): array {
        return self::$rewardsCategoriesStrs;
    }

    /**
     * @return HasMany
     */
	public function customers(): HasMany {
		return $this->hasMany(Customer::class, 'customercategory_id');
	}

    /**
     * @return string
     */
    public function getCustCategory(): string {
        return $this->cust_category;
    }

    /**
     * @return string
     */
    public function getCustCategoryDesc(): string {
        return $this->cust_category_desc;
    }

    /**
     * @return bool
     */
    public function isRewardsCategory(): bool {
        return in_array($this->cust_category, self::$rewardsCategoriesStrs);
    }

    /**
     * @return string of Rewards customer category descriptions and codes
     */
    public static function getRewardsEligibleCategoriesStrForDisplay() {
        return CustomerCategory::whereIn('cust_category', self::$rewardsCategoriesStrs)
            ->selectRaw("GROUP_CONCAT(CONCAT(cust_category, ' (', cust_category_desc, ')')) AS categories")
            ->first()
            ->categories;
    }
}
