<?php

namespace Hilco\Models;

use Auth;
use DB;
use Illuminate\Database\Eloquent\Model;

class WebCart extends WebModel
{
    protected $table = 'WebCarts';
    protected $fillable = ['quantity', 'comment'];

    public function webPart() {
        return $this->hasOne(WebPart::class, 'part_number', 'part_number');
    }

    public function webUser() {
        return $this->hasOne(WebUser::class, 'webuser_id', 'id');
    }

    public function priceList() {
//        return $this->hasOne(PriceList::class)
    }

    public function scopeForUser($query, $webuserId) {
        return $query->where('webuser_id', $webuserId);
    }

    public function scopePartNumber($query, $partNumber) {
        return $query->where('part_number', $partNumber);
    }

//    public function product() {
//        return $this->belongsTo(Product::class);
//    }

    public function getExtendedPriceAttribute() {
        return $this->webPart->getCustomerPrice($this->quantity) * $this->quantity;
    }

    public static function add(WebPart $webPart, $quantity = 1)
    {
        $instance = new static;
        $instance->webuser_id = Auth::id();
        $instance->part_number = $webPart->part_number;
        $instance->quantity = $quantity;
        $instance->save();
        return $instance;
    }

    public static function remove($userId, $partNumber)
    {
        $instance = new static;
        return $instance::where(['part_number' => $partNumber, 'webuser_id' => $userId])->delete();
    }

    public static function cartStatus(WebSilo $webSilo = null, WebUser $webUser = null, Customer $soldToCustomer = null) {
        if (is_null($webSilo)) $webSilo = b2b()->activeWebSilo();
        if (is_null($webUser)) $webUser = auth()->user();
        if (is_null($soldToCustomer)) $soldToCustomer = b2b()->activeCustomer();

        if (is_null($webSilo) || is_null($webUser) || is_null($soldToCustomer)) return [];

        $status = [
            'itemsCount' => 0,
            'quantityCount' => 0,
            'baseTotal' => 0,
            'discountedTotal' => 0,
            'discounts' => [
                'rewards' => 0,
                'customer' => 0,
            ],
            'productCategoryTotals' => [],
            'rewardsUpgradeSpending' => 0,
            'rewardsTier' => rewards()->tier($soldToCustomer),
        ];

        $items = [];

        $customerPriceListName = array_get($soldToCustomer, 'activeSegment.def_price_list');
        $currencyCode = $soldToCustomer->currency;
        $siloPriceListName = $webSilo->priceList;

        $webCartItems = self
            ::where('webuser_id', ($webUser->id))
            ->with('webPart.part.productFamily.productCategory.productCategoryGroup')
            ->get()
        ;

        $distinctPartQuantities = [];
        foreach ($webCartItems as $webCartItem) array_increment($distinctPartQuantities, $webCartItem->webPart->part->id, $webCartItem->quantity);

        $customerPrices = PriceList
            ::where('price_list', '=', $customerPriceListName)
            ->where('currency', '=', $currencyCode)
            ->whereIn('part_id', array_keys($distinctPartQuantities))
            ->orderBy('quantity_level', 'DESC')
            ->get();

        $siloPrices = PriceList
            ::where('price_list', '=', $siloPriceListName)
            ->where('currency', '=', $currencyCode)
            ->whereIn('part_id', array_keys($distinctPartQuantities))
            ->orderBy('quantity_level', 'DESC')
            ->get();

        foreach ($webCartItems as $webCartItem) {
            /**
             * @var Part $part
             */
            $part = $webCartItem->webPart->part;

            $partTotalQuantity = array_get($distinctPartQuantities, $part->id, 0);

            $customerPriceList = PriceList::filterForPartQuantity($customerPrices, $part->id, $partTotalQuantity);

            if ($customerPriceList) {
                $basePrice = $customerPriceList->price;
                $isContractPrice = $customerPriceList->contract_flag;
                $usedPriceList = $customerPriceListName;
            } else {
                $siloPriceList = PriceList::filterForPartQuantity($siloPrices, $part->id, $partTotalQuantity);
                if ($siloPriceList) {
                    $basePrice = $siloPriceList->price;
                    $isContractPrice = false;
                    $usedPriceList = $siloPriceListName;
                } else {
                    $basePrice = $part->getListPriceForCurrencyCode($currencyCode);
                    $isContractPrice = false;
                    $usedPriceList = 'PART_TABLE_LIST_PRICE';
                }
            }

            $discountPercent = 0;
            $baseDiscountAmount = 0;
            $extendedDiscountAmount = 0;
            $discounts = [];
            $discountedPrice = $basePrice;
            $extendedBasePrice = $basePrice * $webCartItem->quantity;

            if (!$isContractPrice) {
                $itemDiscounts = $part->getApplicableDiscounts($soldToCustomer);

                foreach ($itemDiscounts as $discount) {
                    $dPercent = $discount['percent'];
                    $dAmount = round($basePrice * ($dPercent/100), 2);
                    $discountPercent += $dPercent;

                    array_increment($discounts, "$discount[type].percent", $dPercent);
                    array_increment($discounts, "$discount[type].baseAmount", $dAmount);
                    array_increment($discounts, "$discount[type].extendedAmount", $dAmount * $webCartItem->quantity);
//                    array_increment($discounts, "$discount[type].amount", 0);
                }

                $baseDiscountAmount = round($basePrice * ($discountPercent/100), 2);
                $extendedDiscountAmount = round($extendedBasePrice * ($discountPercent/100), 2);
                $discountedPrice = $basePrice - $baseDiscountAmount;
            }

            $extendedPrice = $discountedPrice * $webCartItem->quantity;

            $items[$webCartItem->id] = collect([
                'id' => $webCartItem->id,
                'webCart' => $webCartItem,
                'webPart' => $webCartItem->webPart,
                'part' => $webCartItem->webPart->part,
                'quantity' => $webCartItem->quantity,
                'basePrice' => $basePrice,
                'discountedPrice' => $discountedPrice,
                'baseDiscountAmount' => $baseDiscountAmount,
                'discountPercent' => $discountPercent,
                'extendedBasePrice' => $extendedBasePrice,
                'extendedPrice' => $extendedPrice,
                'extendedDiscountAmount' => $extendedDiscountAmount,
                'discounts' => $discounts,
                'isContractPrice' => $isContractPrice,
                'usedPriceList' => $usedPriceList,
            ]);
            array_increment($status, 'itemsCount');
            array_increment($status, 'quantityCount', $webCartItem->quantity);
            array_increment($status, 'baseTotal', $extendedBasePrice);
            array_increment($status, 'discountedTotal', $extendedPrice);

            foreach ($discounts as $discountType => $discountInfo) {
                array_increment($status, "discounts.$discountType", $discountInfo['extendedAmount']);
            }

            $productCategoryGroupId = $part->productFamily->productCategory->productCategoryGroup->id;
            array_increment($status, "productCategoryTotals.$productCategoryGroupId", $extendedPrice);
        }

        if (rewards()->isRegistered()) {
            $rewardsUpgradeSpending = rewards()->calculateUpgradeSpending($status, $soldToCustomer);
            $status['rewardsUpgradeSpending'] = $rewardsUpgradeSpending;
        }

        if ($status['rewardsUpgradeSpending'] <= 0) { //Tier Upgrade
            $status['baseRewardsTier'] = $status['rewardsTier'];
            $status['rewardsTier'] = min(4, rewards()->tier() + 1);
            $status['upgradedTier'] = min(4, rewards()->tier() + 1);

            $rewardsDiscountTotal = 0;
            foreach ($items as $itemKey => $item) {
//                if (array_has($item, 'discounts.rewards')) {
                    $discountPercent = rewards()->discountForPartTier($item['part']->id, $status['upgradedTier'], $soldToCustomer);
                    $discountAmount = round($item['basePrice'] * ($discountPercent/100), 2);
                    $extendedDiscountAmount = $discountAmount * $item['quantity'];
                    $baseDiscountAmount = round($item['basePrice'] * ($discountPercent/100), 2);
                    $discountedPrice = $basePrice - $baseDiscountAmount;
                    $extendedPrice = $discountedPrice * $item['quantity'];
                    $rewardsDiscountTotal += $extendedDiscountAmount;

                    $item->put('discounts.rewards.percent', $discountPercent);
                    $item->put('discounts.rewards.baseAmount', $discountAmount);
                    $item->put('discounts.rewards.extendedAmount', $extendedDiscountAmount);
                    $item->put('discountPercent', $discountPercent);
                    $item->put('baseDiscountAmount', $discountAmount);
                    $item->put('extendedDiscountAmount', $extendedDiscountAmount);
                    $item->put('discountedPrice', $discountedPrice);
                    $item->put('extendedPrice', $extendedPrice);
//                }
            }
            $status['discounts']['rewards'] = $rewardsDiscountTotal;
        }

        $status['items'] = $items;
        return $status;
    }

//    public static function cartItems($webUserId = false, $billToCustomerSegmentId = false) {
//        // Get the web user. If and ID is provided, use it, otherwise, use who ever is logged in.
//        if ($webUserId === false)
//            $webUser = auth()->user();
//        else
//            $webUser = WebUser::find($webUserId);
//        if (is_null($webUser)) return [];
//
//        // Get the sold to customer.
//        $soldToCustomer = b2b()->activeCustomer();
//
//        // Get the bill to customer. If an ID is provided, us it, otherwise, use the sold to customer.
//        if ($billToCustomerSegmentId === false) {
//            $billToCustomerSegment = $soldToCustomer->activeSegment;
//        } else {
//            $billToCustomerSegment = CustomerSegment::find($billToCustomerSegmentId);
//        }
//        if (is_null($billToCustomerSegment)) return [];
//
//        // Get the two price lists. First is the price lsit for the bill to customer, the second is the default for the silo (Catalog most likely)
//        $customerPriceList = $billToCustomerSegment->def_price_list;
//        $siloPriceList = b2b()->activeWebSilo()->priceList;
//
//        // Get all of the cart items for the user.
//        $cartItems = self::forUser($webUser->id)->with(['webPart' => function ($query) use ($webUser) {
//            return $query->with([
//                'part' => function ($query) use ($webUser) {
//                    $query->with(['prices' => function ($query) use ($webUser) {
//                        $query
//                            ->where('currency', $webUser->currency)
//                            ->where('price_list', $webUser->default_price_list)
//    //                        ->whereRaw('PriceLists.quantity_level >= WebCarts.quantity')
//                        ;
//                    }])->with('productFamily.productCategory.productCategoryGroup');
//                },
//            ])->with('webFamily');
//        }])->get();
//
//        // Loop through all of the items a get a count for each.
//        // Because the same item can have multiple entries, we need a sum for each part id.
//        $totalPromoQuantity = 0;
//        $partsByPrice = [];
//        $priceListQuantityArray = [];
//
//        foreach ($cartItems as $cartItem) {
//            if (isset($priceListQuantityArray[$cartItem->webPart->id])) {
//                $priceListQuantityArray[$cartItem->webPart->id] += $cartItem->quantity;
//            } else {
//                $priceListQuantityArray[$cartItem->webPart->id] = $cartItem->quantity;
//            }
//
////            // At this time we do a quick calculation for the Jonathan Paul promotion.
////            foreach($cartItem->webPart->webFamily->webCollections as $collection) {
////                if ($collection->id == config("hilco.jpPromoCollectionId") && !in_array($cartItem->webPart->webFamily->id, explode('^', config('hilco.jpPromoIgnoreId')))) {
////                    $totalPromoQuantity += $cartItem->quantity;
////                    $partsByPrice[''.$cartItem->webPart->getCustomerPrice($cartItem->quantity)][$cartItem->id] = $cartItem->quantity;
////                    break;
////                }

////            }
//        }
//
//        // Loop through each part again and calculate the prices...
//        foreach ($cartItems as $key => $cartItem) {
//            if (isset($priceListQuantityArray[$cartItem->webPart->id])) {
//                $part = $cartItem->webPart->part;
//
//                // First we need the total quantity calculated above.
//                $cartItems[$key]->priceListQuantity = $priceListQuantityArray[$cartItem->webPart->id];
//
//                // Next we use the total quantity to find the correct price list given the part, bill to price list, currency, and quantity.
//                $priceList = PriceList::where('currency', b2b()->activeCurrency())->where('price_list', '=', $customerPriceList)->where('part_id', '=', $part->id)->where('quantity_level', '<=', $priceListQuantityArray[$cartItem->webPart->id])->orderBy('quantity_level', 'DESC')->first();
//                // If no price list exists, we do the same thing, but with the silo's default price list.
//                if ($priceList == null) {
//                    $priceList = PriceList::where('currency', b2b()->activeCurrency())->where('price_list', '=', $siloPriceList)->where('part_id', '=', $part->id)->where('quantity_level', '<=', $priceListQuantityArray[$cartItem->webPart->id])->orderBy('quantity_level', 'DESC')->first();
//                }
//
//                if ($priceList !== null) {
//                    $cartItems[$key]->priceListPrice = $priceList->price;
//                    $cartItems[$key]->unconvertedPrice = $priceList->price;
//                } else {
//                    // If we still don't have a price list, we use the price in the part table.
//                    $cartItems[$key]->unconvertedPrice = $part->list_price;
//                    if (b2b()->activeCurrency() === 'USD') {
//                        $cartItems[$key]->priceListPrice = $part->list_price;
//                    } else {
//                        // If the customer does not use USD, then we need to convert to their price.
//                        $rate = CurrencyRate::where('year', '<=', 2017)->where('month', '<=', 3)->where('USD', '>', 0)->where(b2b()->activeCurrency(), '>', 0)->where('deleted_at', '=', '0000-00-00 00:00:00')->orderBy('year', 'DESC')->orderBy('month', 'DESC')->value(b2b()->activeCurrency());
//                        if ($rate != null && $rate > 0) {
//                            $cartItems[$key]->priceListPrice = round($part->list_price * $rate, 2);
//                        } else {
//                            $cartItems[$key]->priceListPrice = $part->list_price;
//                        }
//                    }
//                }
//
//                $cartItems[$key]->contract_flag = $priceList !== null && $priceList->contract_flag;
//                $cartItems[$key]->discountedPrice = $cartItems[$key]->priceListPrice;
//
//                // If the price list doesn't have the contract flag set, calculate discounts.
//                if (!$cartItems[$key]->contract_flag) {
//                    $cartItems[$key]->discountedPrice -= round($cartItems[$key]->priceListPrice  * ($part->getCustomerDiscount($soldToCustomer) / 100), 2);
//                    $cartItems[$key]->appliedDiscounts = $part->getApplicableDiscounts($soldToCustomer);
//                }
//
//                $cartItems[$key]->preRewardsPrice = $cartItems[$key]->discountedPrice;
//
//                // Set the final price.
//                $cartItems[$key]->calculatedPrice = $cartItems[$key]->discountedPrice * $cartItems[$key]->quantity;
//                $cartItems[$key]->product_category_group = $part->productFamily->productCategory->productCategoryGroup->product_category_group;
//            }
//        }
//
//        // Promo stuff.
//        if ($totalPromoQuantity > 12) {
//            ksort($partsByPrice, SORT_NUMERIC);
//
//            $discountedFrameCount = $totalPromoQuantity > 13 ? 2 : 1;
//
//            $freeWebCartIds = [];
//            foreach ($partsByPrice as $price => $webCartIds) {
//                foreach ($webCartIds as $webCartId=>$quantity) {
//                    $freeWebCartIds[$webCartId] = min($discountedFrameCount, $quantity);
//                    $discountedFrameCount -= $freeWebCartIds[$webCartId];
//
//                    if ($discountedFrameCount <= 0) break;
//                }
//                if ($discountedFrameCount <= 0) break;
//            }
//
//            foreach ($cartItems as $key=>$cartItem) {
//                if(isset($freeWebCartIds[$cartItem->id])) {
//                    $cartItems[$key]->promo_quantity = $freeWebCartIds[$cartItem->id];
//                    $cartItems[$key]->promoPrice = $cartItems[$key]->discountedPrice * ($cartItems[$key]->quantity - $cartItems[$key]->promo_quantity);
//                }
//            }
//        }
//
//        return $cartItems;
//    }

}
