<?php

namespace Hilco\Models;

use Debugbar;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Venturecraft\Revisionable\RevisionableTrait;

class WebSilo extends WebModel implements HasLandingPageInterface {
	protected $table = "WebSilos";
	protected $fillable = ['contactus_id', 'name', 'slug', 'webRoleIds', 'is_visible', 'is_default', 'detail', 'default_price_list', 'contact_phone', 'contact_email'];
    protected $appends = ['urls'];
	protected $casts = [
	    'is_visible' => 'boolean'
	];

	public function webGroups() {
		return $this->belongsToMany(WebGroup::class, 'WebGroup_WebSilo', 'websilo_id', 'webgroup_id')->withPivot('display_order');
	}

    public function visibleWebGroups() {
        return $this->belongsToMany(WebGroup::class, 'WebGroup_WebSilo', 'websilo_id', 'webgroup_id')
            ->withPivot('display_order')
            ->visible()
            ->displayOrder()
        ;
    }

	public function contactUs() {
		return $this->belongsTo(WebContactUs::class, 'contactus_id', 'id');
	}

	public function webLinkCategories() {
		return $this->belongsToMany(WebCategory::class, 'WebLinkCategory_WebSilo', 'websilo_id', 'weblinkcategory_id');
	}

	public function webLinks() {
		return $this->belongsToMany(WebCategory::class, 'WebLink_WebSilo', 'websilo_id', 'weblink_id');
	}

	public function webUrl() {
	    return $this->hasOne(WebUrl::class, 'websilo_id', 'id');
    }

	public function featuredChildren() {
	    return $this->webGroups();
    }

    public function divisionRules() {
        return $this->belongsToMany(Division::class, 'WebSilo_Division', 'websilo_id', 'division_id');
    }

    public function customerCategorySummaryRules() {
        return $this->belongsToMany(CustomerCategorySummary::class, 'WebSilo_CustomerCategorySummary', 'websilo_id', 'customercategorysummary_id');
    }

    public function webCustomerTypeRules() {
        return $this->belongsToMany(WebCustomerType::class, 'WebSilo_WebCustomerType', 'websilo_id', 'webcustomertype_id');
    }

    public function getDivisionsAttribute() {
        return $this->divisionRules->pluck('id')->toArray();
    }

    public function setDivisionsAttribute($ids) {
        $this->divisionRules()->sync($ids);
    }

    public function criteria() {
        return $this->hasMany(WebSiloCriterion::class, 'websilo_id', 'id');
    }

    public function getUrlsAttribute() {
        $criteria = $this->criteria()->type('url')->get()->map(function($item) {
            return $item['value'];
        })->toArray();
        return $criteria;
    }

    public function setUrlsAttribute($value) {
        $criterion = WebSiloCriterion::all()->where('value', $value);
        foreach ($value as $url) {

        }
    }

    public function getCustomerCategorySummariesAttribute() {
        return $this->customerCategorySummaryRules->pluck('id')->toArray();
    }

    public function setCustomerCategorySummariesAttribute($ids) {
        $this->customerCategorySummaryRules()->sync($ids);
    }

    public function getWebCustomerTypesAttribute() {
        return $this->webCustomerTypeRules->pluck('id')->toArray();
    }

    public function setWebCustomerTypesAttribute($ids) {
        $this->webCustomerTypeRules()->sync($ids);
    }

    /**
     * @return BelongsToMany $this
     */
    public function plants() {
        return $this->belongsToMany(Plant::class, 'Plant_WebSilo', 'websilo_id', 'plant_id')->withPivot('web_flags');
    }

	public function setWebRoleIdsAttribute($ids) {
		$this->save();
		$this->webRoles()->sync($ids);
	}

	public function getAssetPrefix() {
		return "WebSilos/{$this->id}/webContexts";
	}

	public function scopeVisible(Builder $query) {
		return $query
			->where('WebSilos.is_visible', '1')
//			->whereHas('webGroups', function ($query) {
//				return $query->visible();
//			})
		;
	}

	public function scopeCurrent(Builder $query) {
        $query->where('id', self::currentId());
    }

    public static function currentId() {
        $currentSiloId = session()->get('currentWebSiloId', false);
        if (!$currentSiloId) {
            $query = self::query();
            $customer = false;
            $user = auth()->user();
            if (!is_null($user)) $customer = auth()->user()->active_customer;
            if ($customer) {
                $cust_cat_summary = $customer->customerCategory->cust_cat_summary;
                $divisions = $customer->divisions->pluck('id');
                $query->whereHas('divisionRules', function ($query) use ($divisions) {
                    $query->whereIn('Divisions.id', $divisions);
                })->whereHas('customerCategorySummaryRules', function ($query) use ($cust_cat_summary) {
                    $query->where('cust_cat_summary', $cust_cat_summary);
                });
            } else {
                $webUrl = WebUrl::current()->first();
                if (!is_null($webUrl)) {
                    $query->whereHas('webUrl', function ($query) use ($webUrl) {
                        $query->where('id', '=', $webUrl->id);
                    });
                }
            }

            $currentSiloId = $query->first()->id;
            session()->set('currentWebSiloId', $currentSiloId);
        }
        return $currentSiloId;
    }

    public function scopeNavbarMenu(Builder $query) {
        return $query->with(['webGroups' => function ($query) {
            return $query->orderBy('pivot_display_order', 'asc')->orderBy('name', 'asc');
        }]);
//            ->join('WebGroup_WebSilo as WGWS', 'WGWS.websilo_id', '=', 'WebSilos.id')
//            ->join('WebCategory_WebGroup as WCWG', 'WCWG.webcategory_id', '=', 'WGWS.webgroup_id')
//            ->join('WebCollection_WebCategory as WLWC', 'WLWC.webcollection_id', '=', 'WCWG.webcollection_id')
//            ->join('WebGroups', 'WebGroups.id', '=', 'WGWS.webgroup_id')
//            ->join('WebCategories', 'WebCategories.id', '=', 'WCWG.webcategory_id')
//            ->join('WebCollections', 'WebCollections.id', '=', 'WLWC.webcollection_id')
//            ->orderBy('WGWS.display_order', 'asc')
//            ->orderBy('WebGroups.name', 'asc')
//            ->orderBy('WCWG.display_order', 'asc')
//            ->orderBy('WebCategories.name', 'asc')
//            ->orderBy('WLWC.display_order', 'asc')
//            ->orderBy('WebCollections.name', 'asc')
//            ->select(DB::raw('WebSilo.*'))
//            ->groupBy('WebGroups.id')
        ;
    }

//	public static function current() {
//	    $webSilo = null;
//        if (auth()->user()) {
////            $customer = auth()->user()->customer;
////            dd($customer);
//        } else {
//            $webUrl = WebUrl::current($_SERVER['HTTP_HOST']);
//            if (!is_null($webUrl)) $webSilo = $webUrl->webSilo;
//        }
//        if (is_null($webSilo)) $webSilo = WebSilo::first();
//        return $webSilo;
//    }

    public function slugUrl() {
        //return route('silos.slug', [$this->slug]);
    }

    use HasSlug, HasLandingPage, RevisionableTrait;

    public function getParentRelationName() {
        return false;
    }
}
