@if($edit)
    @if($wrap) <div class="mceNonEditable component-container" data-component-key="jumbotron"> @endif
        <h4>Jumbotron</h4>
        <p>Displays a large banner across the entire width of the page.</p>
        <img data-web-asset-id="{{ $webAssetId }}" id="jumbotronThumbnail" src="{{ webAssetUrl($webAssetId) }}" class="img-responsive center-block">
    @if($wrap) </div> @endif
@endif

@if($script)
    <script type="text/javascript">
        registerComponent('jumbotron', {
            menuText: 'Jumbotron',
            bladeTemplate: 'hilco::components.jumbotron',
            init: function (body) {
                $(body).on('click', '#jumbotronThumbnail', function() {
                    assets.finder({
                        successFunction: function(data) {
                            $(body).find('img#jumbotronThumbnail')
                                    .attr('src', data.url)
                                    .attr('data-web-asset-id', data.id)
                            ;
                        }
                    });
                });
            },
            serialize: function (componentNode) {
                return {
                    webAssetId: $(componentNode).find('img#jumbotronThumbnail').data('web-asset-id')
                }
            },
        });
    </script>
@endif

@if($view)
    <div class="row">
        <div class="col-xs-12">
            <img style="width: 100%;" class="img-responsive" src="{{webAssetUrl($webAssetId)}}" alt="">
        </div>
    </div>
    <br>
@endif
