<script type="text/javascript">
    var customerCategories = {!! \Hilco\Models\CustomerCategory::orderBy('cust_category')->pluck('cust_category')->toJson() !!};
    var userPersonas = [
        @foreach(\Hilco\Models\WebUserPersona::orderBy('name')->get() as $userPersona)
            {"label":"{!! $userPersona->name !!}" , "value": "{!! $userPersona->slug !!}"},
        @endforeach
    ];
    var viewFunctionsInit = false;

    function initViewFunctions(body) {
        if (viewFunctionsInit === false) {
            viewFunctionsInit = true;
            $(body).on('click', 'a.add-dynamic-view', function () {
                var viewContainer = $(this).closest('div.view-full-container');

                //Add a new Tab
                var tabContainer = viewContainer.find('ul.visibility-controls');
                var altViewTabs = tabContainer.find('.alt-view');
                if (altViewTabs.length > 0) {
                    lastAltViewTab = altViewTabs.last();
                    var newAltViewId = parseInt(lastAltViewTab.attr('data-view-id')) + 1;
                } else {
                    var newAltViewId = 1;
                }
                var newAltViewTab = '<li role="presentation"><a class="change-dynamic-view alt-view" title="@lang('hilco::app.target_customers_colon') None" href="#" data-view-id="' + newAltViewId + '">@lang('hilco::app.alternate') ' + newAltViewId + '</a></li>';
                var addListItem = tabContainer.find('li.add-dynamic-view-parent');
                //gotta remove the a tag's parent li and re-add it at the end to keep the options pretty
                addListItem.remove();
                tabContainer.append(newAltViewTab);
                tabContainer.append(addListItem);

                //Add a new view

                var templateView = viewContainer.find('div.view-container.default');

                var newView = templateView.clone();
                newView.attr('data-view-id', newAltViewId);
                newView.removeClass('default');
                newView.removeClass('visible');
                newView.addClass('alternate');
                newView.addClass('hidden');

                var deleteButton = newView.find('.delete-view-button');
                deleteButton.removeClass('delete-view-button');
                deleteButton.removeClass('hidden');
                deleteButton.addClass('delete-alternate-button');
                deleteButton.attr('title', "@lang('hilco::app.delete_alternate_description')");
                deleteButton.html("@lang('hilco::app.delete_alternate')");

                var visibilitySpan = newView.find('.visibility-options');
                visibilitySpan.attr('title', '@lang('hilco::app.target_customers_description')');
                visibilitySpan.html("@lang('hilco::app.target_customers_colon')");

                var visibilityAnchor = newView.find('.view-defaultvisibility');
                visibilityAnchor.removeClass('view-defaultvisibility');
                visibilityAnchor.addClass('view-targetcustomers');
                visibilityAnchor.html("None");

                viewContainer.append(newView);
            });

            $(body).on('click', 'a.change-dynamic-view', function () {
                var viewContainer = $(this).closest('div.view-full-container');

                //change active tab
                var tabContainer = viewContainer.find('ul.visibility-controls');
                var currentTab = tabContainer.find('li.active');
                var newTab = $(this).closest('li');
                currentTab.removeClass('active');
                newTab.addClass('active');

                //change visible view
                var currentView = viewContainer.find('div.visible');
                var newView = viewContainer.find('div.view-container[data-view-id="' + $(this).attr('data-view-id') + '"]');

                currentView.removeClass('visible');
                currentView.addClass('hidden');
                newView.removeClass('hidden');
                newView.addClass('visible');
            });

            $(body).on('click', 'a.delete-alternate-button', function () {
                var viewContainer = $(this).closest('div.view-full-container');

                //remove tab
                var tabContainer = viewContainer.find('ul.visibility-controls');
                tabContainer.find('li.active').remove();

                //change tab back to default
                tabContainer.find('a.default-view').closest('li').addClass('active');

                //remove view
                var view = $(this).closest('.view-container');
                var viewId = parseInt(view.attr('data-view-id'));
                $(view).remove();

                //change view back to default
                var newView = viewContainer.find('div.view-container.default');
                newView.removeClass('hidden');
                newView.addClass('visible');

                //reduce the index of all subsequent alt-view views
                viewContainer.find('div.view-container.alternate').each(function () {
                    var altViewId = parseInt($(this).attr('data-view-id'));
                    if (altViewId > viewId) {
                        altViewId--;
                        $(this).attr('data-view-id', altViewId);
                    }
                });
                //reduce the index of all subsequent alt-view tabs
                tabContainer.find('a.alt-view').each(function () {
                    var altViewId = parseInt($(this).attr('data-view-id'));
                    if (altViewId > viewId) {
                        altViewId--;
                        $(this).html('@lang('hilco::app.alternate') ' + altViewId);
                        $(this).attr('data-view-id', altViewId);
                    }
                });
            });
            $(body).on('click', '.view-targetcustomers', function () {
                var view = $(this).closest('.view-container');

                var targetCustomers = {customerCategories: [], userPersonas: []};
                try {
                    targetCustomers = JSON.parse($(view).attr('data-target-customers'));
                } catch (e) {
                    //not valid json, use the default empty arrays
                }
                var targetCustomersEditor = new $.fn.dataTable.Editor({
                    title: 'Target Customers',
                    fields: [
                        {
                            label: 'Customer Categories',
                            name: 'customerCategories',
                            type: 'select2',
                            multiple: true,
                            attr: {
                                multiple: 'multiple'
                            },
                            options: customerCategories,
                            def: targetCustomers.customerCategories,
                        },
                        {
                            label: 'User Personas',
                            name: 'userPersonas',
                            type: 'select2',
                            multiple: true,
                            attr: {
                                multiple: 'multiple'
                            },
                            options: userPersonas,
                            def: targetCustomers.userPersonas,
                        },
                    ]
                }).title('@lang('hilco::app.target_customers')').buttons({
                    label: "@lang('hilco::app.save')",
                    fn: function () {
                        this.submit(null, null, function (data) {
                            var targetCustomersFormatted = '';
                            var delim = '';
                            var targetCustomers = {}
                            $.each(data.data.key, function (dataType, values) {
                                targetCustomers[dataType] = [];
                                $.each(values, function (index, value) {
                                    if (dataType === 'userPersonas'){
                                        if (value !== '') {
                                            var labelValue = value;
                                            $.each(userPersonas, function (index, row){
                                                if (row.value === value){
                                                    labelValue = row.label;
                                                }
                                            })
                                            targetCustomersFormatted += delim + labelValue;
                                            delim = ', ';
                                            targetCustomers[dataType].push(value);
                                        }
                                    }else{
                                        if (value !== '') {
                                            targetCustomersFormatted += delim + value;
                                            delim = ', ';
                                            targetCustomers[dataType].push(value);
                                        }
                                    }
                                });
                            });

                            if (targetCustomersFormatted === '') {
                                targetCustomersFormatted = 'None';
                            }

                            targetCustomersFormatted;

                            var targetCustomersJson = JSON.stringify(targetCustomers);
                            $(view).attr('data-target-customers', targetCustomersJson);
                            $(view).find('.view-targetcustomers').text(targetCustomersFormatted);
                            $(view).closest('.view-full-container').find('.visibility-controls').find('a.change-dynamic-view[data-view-id="' + $(view).attr('data-view-id') + '"]').attr('title', "@lang('hilco::app.target_customers_colon') " + targetCustomersFormatted);
                        });
                    }
                });

                //editor requires a key in the data.data object to notate what we're looking for, just using 'key' as a placeholder
                targetCustomersEditor.edit('key');
            });
            $(body).on('click', '.view-defaultvisibility', function () {
                var view = $(this).closest('.view-container');

                defaultvisibility = $(view).attr('data-default-visibility').trim();
                if (defaultvisibility !== 'Hidden') {
                    defaultvisibility = 'Visible';
                }

                var defaultVisibilityEditor = new $.fn.dataTable.Editor({
                    title: 'Default Visibility',
                    fields: [
                        {
                            label: 'Default Visibility',
                            name: 'defaultVisibility',
                            type: 'select',
                            options: ['Visible', 'Hidden'],
                            def: defaultvisibility,
                        }
                    ]
                }).title('@lang('hilco::app.default_visibility')').buttons({
                    label: "@lang('hilco::app.save')",
                    fn: function () {
                        this.submit(null, null, function (data) {
                            var defaultVisibility = data.data.key.defaultVisibility;

                            $(view).attr('data-default-visibility', defaultVisibility);
                            $(view).find('.view-defaultvisibility').text(defaultVisibility);
                        });
                    }
                });

                //editor requires a key in the data.data object to notate what we're looking for, just using 'key' as a placeholder
                defaultVisibilityEditor.edit('key');
            });
        }
    }
</script>