@if(isset($mode) && $mode === 'view')
    <div class="row @if(!isset($isInLayout)) container @endif center-block">
        @foreach ($tiles as $tile)
            <div class="col-tn-12 col-xs-8 col-xs-offset-2 @if(!isset($tile['tileSize'])) col-sm-4  @else col-sm-{{$tile['tileSize']}} @endif col-sm-offset-0">
                <a href="{{ webLinkUrl($tile['link']) }}">
                    <img class="img-responsive center-block" src="{{ webAssetUrl($tile['webAssetId']) }}" alt="@if(isset($tile['alttag']))  {{ $tile['alttag'] }} @endif">
                </a>
                <div class="visible-tn visible-xs">
                    <br>
                </div>
            </div>
        @endforeach
        <div class="clearfix" style="margin-bottom: 20px"></div>
    </div>
@else
    <div class="view-container {{$default? 'default visible' : 'alternate hidden'}}" data-view-id="{{$viewId}}" data-target-customers="@if(isset($targetCustomers))  {{ json_encode($targetCustomers) }} @endif" data-default-visibility="@if(isset($defaultVisibility) && trim($defaultVisibility) != "")  {{ $defaultVisibility }} @else Visible @endif">
        <div class="row tiles-container">
            @foreach($tiles as $tileId => $tile)
                <div data-tile-id="{{ $tileId }}" data-link-type="{{ Arr::get(Arr::get($tile, 'link', []),'type', '') }}"
                     data-link-target="{{ Arr::get(Arr::get($tile, 'link', []),'target', '') }}" data-web-asset-id="{{ Arr::get($tile, 'webAssetId', '') }}" data-img-alttag="@if(isset($tile['alttag']))  {{ $tile['alttag'] }} @endif"
                     @if( $tile['tileSize'] !== null) data-tile-size="{{ $tile['tileSize']}}" @else data-tile-size="12" @endif
                     class="tile-container col-sm-12 col-md-4">
                    <img class="improved-tile-thumbnail center-block img-responsive"
                         src="{{ webAssetUrl(Arr::get($tile, 'webAssetId', '')) }}" alt="@if(isset($tile['alttag']))  {{ $tile['alttag'] }} @endif">
                    @lang('hilco::app.destination_colon') <a href="#"
                                                             class="improved-tile-link">{!! strlen(webLinkTitle(Arr::get($tile, 'link', []))) ? webLinkTitle(Arr::get($tile, 'link', [])) : '<em>None</em>'  !!}</a>
                    <br>
                    @lang('hilco::app.alternate_tag') <a href="#" class="improved-tile-alttag">@if(isset($tile['alttag']) && trim($tile['alttag']) != "") {{ $tile['alttag'] }} @else None  @endif</a>
                    <div class="image-size" data-img-height="@if(isset($tile['height'])){{ $tile['height'] }}@endif"
                         data-img-width="@if(isset($tile['width'])){{ $tile['width'] }}@endif">
                        @if(isset($tile['height']) && isset($tile['width']) && $tile['height'] != null && $tile['width'] != null) Height: {{ $tile['height'] }}px Width: {{ $tile['width'] }}px @endif
                    </div>
                </div>
            @endforeach
        </div>
        <div class="row">
            <h4 class="current-layout" @if($selectedLayout !== null) data-current-layout="{{ $selectedLayout }}" @else data-current-layout="full" @endif
            @if($displayName !== null) data-display-name="{{ $displayName }}" @else data-display-name="100%" @endif>
                @if($displayName !== null ) Current Layout: {{ $displayName }} @else Current Layout: 100% @endif</h4>
            <button id="changeLayout" class="btn btn-info">Change Layout</button><br>
            @if($default)
                <span class='visibility-options' title="@lang('hilco::app.default_visibility_description')">@lang('hilco::app.default_visibility_colon')</span> <a href="#" class="view-defaultvisibility">@if(isset($defaultVisibility) && trim($defaultVisibility) != "") {{ $defaultVisibility }} @else Visible  @endif</a><br>
                <a class="delete-view-button btn btn-danger hidden" title="@lang('hilco::app.delete_alternate_description')" href="#">@lang('hilco::app.delete_alternate')</a>
            @else
                <span class='visibility-options' title="@lang('hilco::app.target_customers_description')">@lang('hilco::app.target_customers_colon')</span> <a href="#" class="view-targetcustomers">@if(isset($targetCustomersFormatted) && trim($targetCustomersFormatted) != "") {{ $targetCustomersFormatted }} @else None  @endif</a><br>
                <a class="delete-alternate-button btn btn-danger" title="@lang('hilco::app.delete_alternate_description')" href="#">@lang('hilco::app.delete_alternate')</a>
            @endif
        </div>
    </div>
@endif