@if(isset($mode) && $mode === 'view')
    <div>
        @if(Arr::get($slide, 'link')) <a href="{{ webLinkUrl($slide['link']) }}"> @endif
            <img src="{{ webAssetUrl($slide['webAssetId']) }}" alt="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif" />
            @if(Arr::get($slide, 'link')) </a> @endif
    </div>
@else
    <div data-view-id="{{$slideId}}" data-link-type="{{ Arr::get($slide, 'link.type') }}" data-link-target="{{ Arr::get($slide, 'link.target') }}" data-web-asset-id="{{ $slide['webAssetId'] }}" data-img-alttag="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif" data-target-customers="@if(isset($targetCustomers))  {{ json_encode($targetCustomers) }} @endif" data-default-visibility="@if(isset($slide['defaultVisibility']))  {{ $slide['defaultVisibility'] }} @else Visible @endif" class="slide-container view-container {{$default? 'default visible' : 'alternate hidden'}}">
        <div style="margin: 5px; padding: 5px; border: 1px solid black; clear: both;">
            <img class="center-block img-responsive slide-thumbnail" src="{{ webAssetUrl($slide['webAssetId']) }}" alt="@if(isset($slide['alttag']))  {{ $slide['alttag'] }} @endif">
            @lang('hilco::app.destination_colon') <a href="#" class="slide-url">{!! strlen(webLinkTitle(Arr::get($slide, 'link', []))) ? webLinkTitle($slide['link']) : '<em>'.trans('hilco::app.none').'</em>' !!}</a><br>
            @lang('hilco::app.alternate_tag') <a href="#" class="slide-alttag">@if(isset($slide['alttag']) && trim($slide['alttag']) != "") {{ $slide['alttag'] }} @else None  @endif</a><br>
            @if($default)
                <span class='visibility-options' title="@lang('hilco::app.default_visibility_description')">@lang('hilco::app.default_visibility_colon')</span> <a href="#" class="view-defaultvisibility">@if(isset($slide['defaultVisibility']) && trim($slide['defaultVisibility']) != "") {{ $slide['defaultVisibility'] }} @else Visible  @endif</a><br>
                <a class="delete-slide-button delete-view-button btn btn-danger" title="@lang('hilco::app.delete_slide_description')" href="#">@lang('hilco::app.delete_slide')</a>
            @else
                <span class='visibility-options' title="@lang('hilco::app.target_customers_description')">@lang('hilco::app.target_customers_colon')</span> <a href="#" class="view-targetcustomers">@if(isset($targetCustomersFormatted) && trim($targetCustomersFormatted) != "") {{ $targetCustomersFormatted }} @else None  @endif</a><br>
                <a class="delete-alternate-button btn btn-danger" title="@lang('hilco::app.delete_alternate_description')" href="#">@lang('hilco::app.delete_alternate')</a>
            @endif
        </div>
    </div>
@endif