<?php

namespace Hilco\Models;

use Debugbar;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

class WebContactBlock extends WebModel {
	protected $table = "WebContactBlocks";
    protected $fillable = [
        'websilo_id',
        'plant_id',
        'contact_block',
    ];
    protected $appends = [
        'plant_name',
    ];

	public function webSilo() {
		return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
	}

	public function plant() {
	    return $this->belongsTo(Plant::class, 'plant_id', 'id');
    }

    public function scopePlant($query, $plant) {
	    $plantId = \Illuminate\Support\Arr::get($plant, 'id', $plant);

        return $query->where('plant_id', '=', $plantId);
    }

    public function scopeWebSilo($query, $webSilo) {
	    $webSiloId = \Illuminate\Support\Arr::get($webSilo, 'id', $webSilo);

	    return $query->where('websilo_id', '=', $webSiloId);
    }

    public function getPlantNameAttribute() {
	    if (!is_null($this->plant)) return $this->plant->plant;

	    return 'Default';
    }
}
