<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SearchBucketStatic extends Model
{
	use \Hilco\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'SearchBucketStatics';
	protected $fillable = ['bucket_name', 'webattribute_id'];

    public function webAttribute() {
        return $this->belongsTo(WebAttribute::class, 'webattribute_id', 'id');
    }

    public function webAttributePart() {
        return $this->belongsToMany(WebAttribute_WebPart::class, 'SearchBucketStatic_WebAttributeValue', 'searchbucket_id', 'webattributevalue_id');
    }
}
