<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 7/8/16
 * Time: 3:01 PM
 */

namespace Hilco\Controllers;

use Illuminate\Http\Request;
use Response;

trait HasSelect2Search {

    /**
     * Default method, override this for it to work.
     */
    public function getS2SearchModel() {
        return false;
    }

    public function s2search(Request $request) {
        $page = $request->get('page', 0);
        $filters = $request->get('filters', []);
        $q = $this->getS2SearchModel();
        if (!$q) return Response::json([]);

        foreach ($filters as $filter) {
            $column = array_get($filter, 'column');
            $operator = array_get($filter, 'operator', '=');
            $value = array_get($filter, 'value');
            if (strtolower($operator) == 'like') $value = "%$value%";
            $q->where($column, $operator, $value);
        }
        $totalCount = $q->count();
        $results = $q->offset($page * 30)->take(30)->get();
        return Response::json(['items' => $results, 'total_count' => $totalCount, 'page' => $page]);
    }
}