<?php

namespace Hilco\Models;

/**
 * Hilco\Models\ShippingPolicyType
 * @property-read integer $id
 * @property-read string $code
 * @property-read string $description
 * @property-read integer $category
 * @property-read integer $funct_num
 */
class ShippingPolicyType extends WebModel {
    protected $table = "ShippingPolicyTypes";
    protected $connection = 'hilco-live';

    const EXPRESSRX_ORDER_TYPE = "URX";
    const US_FULL = "U03";

    /**
     * @return ShippingPolicyType|null
     */
    public static function getExpressRxType(): ?ShippingPolicyType {
        return ShippingPolicyType::where('code', self::EXPRESSRX_ORDER_TYPE)->first();
    }

    /**
     * @return string
     */
    public function getCode(): string {
        return $this->code;
    }
}