<?php

namespace Hilco\Models;

/**
 * Hilco\Models\Contact
 *
 * @property mixed $id
 * @property integer $customer_id
 * @property string $salutation
 * @property string $first_name
 * @property string $last_name
 * @property string $phone
 * @property string $mobile_phone
 * @property string $fax
 * @property string $email
 * @property string $title
 * @property string $department
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property integer $commit_sequence
 * @property integer $int_id
 * @property integer $activated
 * @property integer $email_optout
 * @property integer $phone_optout
 * @property integer $fax_optout
 * @property string $ext
 * @property string $web_address
 * @property string $last_verified_date
 * @property integer $verifiedby_rep_id
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereSalutation($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereFirstName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereLastName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact wherePhone($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereMobilePhone($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereFax($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereEmail($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereTitle($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereDepartment($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereCommitSequence($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereIntId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereActivated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereEmailOptout($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact wherePhoneOptout($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereFaxOptout($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereExt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereWebAddress($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereLastVerifiedDate($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Contact whereVerifiedbyRepId($value)
 *
 */
class Contact extends UuidModel {
	protected $table = 'Contacts';
    protected $fillable = ['id', 'customer_id', 'salutation', 'first_name', 'last_name', 'phone', 'mobile_phone', 'fax', 'email', 'title', 'department',
                            'activated', 'email_optout', 'phone_optout', 'fax_optout', 'ext', 'web_address', 'last_verified_date', 'verifiedby_rep_id',
                            'commit_sequence'];
    const UPDATED_AT = 'date_modified';
    const CREATED_AT = 'date_created';

    use \Hilco\SoftDeletes;

    public function customer() {
        return $this->belongsTo(Customer::class, 'customer_id', 'id');
    }
}
