<?php

namespace Hilco\Models;

/**
 * Model Class PromotionWebSiloTrigger_WebSilo
 * @property int $promotionwebsilotrigger_id
 * @property int $websilo_id
 * @property PromotionWebSiloTrigger $promotionWebSiloTrigger
 * @property WebSilo $webSilo
 * @method static triggerWebSilo($trigger_id, $websilo_id)
 * @method static byWebSilo($websilo_id)
 * @method static byTrigger($trigger_id)
 */
class PromotionWebSiloTrigger_WebSilo extends WebModel {
    protected $table = "PromotionWebSiloTrigger_WebSilo";
    protected $fillable = ['promotionwebsilotrigger_id', 'websilo_id'];

    public function promotionWebSiloTrigger() {
        return $this->belongsTo(PromotionWebSiloTrigger::class, 'promotionwebsilotrigger_id', 'id');
    }

    public function webSilo() {
        return $this->belongsTo(WebSilo::class, 'websilo_id', 'id');
    }

    public function scopeTriggerWebSilo ($query, $trigger_id, $websilo_id) {
        return $query->where('promotionwebsilotrigger_id', '=', $trigger_id)->where('websilo_id', '=', $websilo_id);
    }

    public function scopeByWebSilo ($query, $websilo_id) {
        return $query->where('websilo_id', '=', $websilo_id);
    }

    public function scopeByTrigger ($query, $trigger_id) {
        return $query->where('promotionwebsilotrigger_id', '=', $trigger_id);
    }
}