<?php

namespace Hilco\Models;

use Carbon\Carbon;

class WebAuthEvent extends WebModel {
    protected $table = 'WebAuthEvents';
    protected $fillable = ['event_type', 'ip_address', 'email', 'webuser_id', 'extra_data'];
    protected $casts = [
        'extra_data' => 'array'
    ];

    public function setIpAddressAttribute($value) {
        $this->attributes['ip_address'] = ip2long($value);
    }

    public function getIpAddressAttribute() {
        return long2ip($this->attributes['ip_address']);
    }

    public function scopeToday($query) {
        return $query->whereBetween('date_created', [Carbon::today()->startOfDay()->toDateTimeString(), Carbon::today()->endOfDay()->toDateTimeString()]);
    }
}