<?php

namespace Hilco\Models;

/**
 * Hilco\Models\ProductFamilies
 *
 * @property mixed $id
 * @property string $product_family_no
 * @property mixed $productcategory_id
 * @property mixed $financialreportgroup_id
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read \Hilco\Models\Product $part
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereProductFamilyNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereProductcategoryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereFinancialreportgroupId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereDeletedAt($value)
 * @mixin \Eloquent
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\ProductFamilies whereDateUploaded($value)
 */
class ProductFamilies extends UuidModel
{
	protected $table = 'ProductFamilies';

	/**
	 * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
	 */
	public function part()
	{
		return $this->belongsTo(Part::class, 'id', 'productfamily_id');
	}
}
