<?php

return [
    'email' => [
        'orderSubmitted' => [
            'destination' => [env('HILCO_CS_EMAIL', 'cbarranco@visionwaresystems.com')],
            'subject' => env('HILCO_ORDER_SUBMITTED_EMAIL_SUBJECT', 'Hilco B2B Order Submitted'),
        ],
        'requestAccountCorrections' => [
            'destination' => ['cbarranco@visionwaresystems.com'],
            'subject' => env('HILCO_ACCOUNT_CORRECTION_EMAIL_SUBJECT', 'Account Correction Request'),
        ],
        'feedback' => [
            'destination' => ['cbarranco@visionwaresystems.com'],
            'subject' => env('HILCO_FEEDBACK_EMAIL_SUBJECT', 'Hilco B2B User Feedback'),
        ],
        'requestCorrections' => [
            'destination' => ['cbarranco@visionwaresystems.com'],
            'subject' => 'Hilco B2B Requested Corrections',
        ],
        'newUserAlert' => [
            'destination' => env('HILCO_NEW_USER_ALERT_EMAIL', 'cbarranco@visionwaresystems.com'),
        ],
    ],
    'customers' => [
        'stats' => [
            'groups' => [
                '' => 'Overall',
                'DIAGNOSTIC EXAM' => 'Diagnostic Exam',
                'REPAIR PARTS' => 'Repair Parts',
                'LAB & DISPENSING EQUIPMENT' => 'Lab & Dispensing Equipment',
                'CONSUMER ACCESSORIES' => 'Consumer Accessories',
                'PHARMACEUTICALS' => 'Pharmaceuticals',
                'SPORT/SUN PROTECTIVE EYEWEAR' => 'Sport / Sun Protective Eyewear',
                'SURGICAL' => 'Surgical',
                'LENSCARE & BRANDING' => 'Lenscare & Branding',
                'LAB SERVICES' => 'Lab Services',
                'INDUSTRIAL SAFETY EYEWEAR' => 'Industrial Safety Eyewear',
            ]
        ]
    ],
    'b2b' => [
        'url' => env('B2B_SERVER_URL')
    ],
    'uac' => [
        'url' => env('UAC_SERVER_URL')
    ],
    'assets' => [
        'url' => env('ASSET_SERVER_URL'),
        'nopic' => 'chrome/nopic',
        'tokenSalt' => 'sfed;ji365wJTEARr8y90fdhjniu',
        'sizes' => [
            'thumbnail' => [
                'width' => 80,
                'height' => 80,
            ],
            'thumbnailByHeight' => [
                'width' => -1,
                'height' => 80,
            ],
            'microByHeight' => [
                'width' => -1,
                'height' => 40,
            ],
            'small' => [
                'width' => 150,
                'height' => 150,
            ],
            'medium' => [
                'width' => 300,
                'height' => 300,
            ],
            'logo' => [
                'width' => -1,
                'height' => 45,
            ]
        ]
    ],
    'components' => [
        'bannerCarousel' => [
            'view' => 'hilco::components.bannerCarousel',
            'defaultViewData' => [
                'bannerId' => '',
                'slides' => [
                    0 => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ],
            ]
        ],
        'jumbotron' => [
            'view' => 'hilco::components.jumbotron',
            'defaultViewData' => [
                'webAssetId' => null,
            ]
        ],
        'promoTiles' => [
            'view' => 'hilco::components.promoTiles',
            'defaultViewData' => [
                'tiles' => [
                    'left' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'center' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'right' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ]
            ]
        ],
        'children' => [
            'view' => 'hilco::components.children',
            'defaultViewData' => [
                'types' => [
                    'children' => 'All',
                    'featuredChildren' => 'Featured',
                ],
                'layouts' => [
                    'normal' => 'Normal',
                    'large' => 'Large',
                    'jumbo' => 'Jumbo',
                ],
                'type' => 'featuredChildren',
                'layout' => 'normal',
                'showNames' => true,
            ]
        ],
        'allChildren' => [
            'view' => 'hilco::components.allChildren',
            'defaultViewData' => [

            ]
        ],
        'userInfo' => [
            'view' => 'hilco::components.userInfo',
            'defaultViewData' => [

            ],
        ],
        'bestSellers' => [
            'view' => 'hilco::components.bestSellers',
            'defaultViewData' => [

            ]
        ],
        'assetsTable' => [
            'view' => 'hilco::components.assetsTable',
            'defaultViewData' => [
                'assetsTableId' => 0,
                'webAssets' => [],
            ]
        ],
        'assetLink' => [
            'view' => 'hilco::components.assetLink',
            'defaultViewData' => [
                'webAssetId' => null,
                'link' => [
                    'type' => null,
                    'target' => null,
                    'isPrivate' => false,
                ],
                'caption' => null,
            ]
        ],
    ],
    'outOfStockLabels' => [
        'Out of Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'inStockLabels' => [
        'In Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'defaultWebRoleSlug' => 'web-user',
    'jpPromoCollectionId' => env("JONATHAN_PAUL_FITOVERS_ID"),
    'jpPromoIgnoreId' => env("JONATHAN_PAUL_FITOVERS_IGNORE_ID"),
];