<?php

namespace Hilco\Models;

trait HasWebSiloOverrides {
    public function webSiloOverrides() {
        return $this
            ->morphMany(WebSiloOverride::class, 'overrideable', 'overrideable_type', 'overrideable_id')
        ;
    }

    public function webSiloOverride() {
        return $this
            ->morphOne(WebSiloOverride::class, 'overrideable', 'overrideable_type', 'overrideable_id')
            ->where('websilo_id', '=', b2b()->activeWebSilo()->id)
        ;
    }

    public function getNameOverrideAttribute($name) {
        $overrideName = array_get($this, 'webSiloOverride.name', null);
        if (strlen($overrideName)) return $overrideName;

        return $this->name;
    }

    public function getDetailOverrideAttribute($detail) {
        $overrideDetail = array_get($this, 'webSiloOverride.detail', null);
        if (strlen(trim($overrideDetail)) > 1) return $overrideDetail;

        return $this->detail;
    }
}