<?php

namespace Hilco\Models;

/**
 * Hilco\Models\OrderSubLine
 *
 * @property mixed $id
 * @property mixed $parent_id
 * @property string $parent_type
 * @property mixed $salesordermainline_id
 * @property integer $division_id
 * @property mixed $salesorder_id
 * @property integer $line_order
 * @property string $line_suborder
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Hilco\Models\OrderMiscLine $miscLine
 * @property-read \Hilco\Models\OrderDiscountLine $discountLine
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereParentId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereParentType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereSalesordermainlineId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereLineSuborder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property integer $line_number
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderSubLine whereLineNumber($value)
 * @property-read \Hilco\Models\OrderAttnLine $attnLine
 * @property-read \Hilco\Models\OrderInstructionLine $instructionLine
 */
class OrderSubLine extends \Eloquent
{
    protected $table = 'SalesOrderSubLines';
//
//    public function order()
//    {
//        return $this->belongsTo(Order::class);
//    }

    public function miscLine()
    {
        return $this->hasOne(OrderMiscLine::class, 'id', 'parent_id');
    }

    public function attnLine()
    {
        return $this->hasOne(OrderAttnLine::class, 'id', 'parent_id');
    }
    
    public function commentLine()
    {
        return $this->hasOne(OrderCommentLine::class, 'id', 'parent_id');
    }

    public function instructionLine()
    {
        return $this->hasOne(OrderInstructionLine::class, 'id', 'parent_id');
    }
    
    public function discountLine()
    {
        return $this->hasOne(OrderDiscountLine::class, 'id', 'parent_id');
    }
}
