<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;

/**
 * Hilco\Models\CustomerShippingAddress
 *
 * @property mixed $id
 * @property string $division
 * @property mixed $division_id
 * @property string $cust_no
 * @property mixed $customerdivision_id
 * @property string $cust_name
 * @property string $addr_no
 * @property string $addr_type
 * @property string $addr_1
 * @property string $addr_2
 * @property string $addr_3
 * @property string $addr_4
 * @property string $addr_5
 * @property string $city
 * @property string $state
 * @property string $postal_cd
 * @property string $country
 * @property string $def_ship_from
 * @property string $def_ship_wh
 * @property string $def_ship_via
 * @property string $def_fob_cd
 * @property string $def_carr_cd
 * @property string $def_carrier
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCustomerdivisionId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddrNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddrType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr1($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr3($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr4($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereAddr5($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereState($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress wherePostalCd($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCountry($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefShipFrom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefShipWh($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefShipVia($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefFobCd($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefCarrCd($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefCarrier($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDeletedAt($value)
 * @mixin \Eloquent
 * @property mixed $carrier_id
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereCarrierId($value)
 * @property string $division
 * @property integer $default_shipfrom_id
 * @property integer $default_fob_id
 * @property string $territory_code
 * @property integer $salesterritory_id
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDivision($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefaultShipfromId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDefaultFobId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereTerritoryCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereSalesterritoryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\CustomerShippingAddress whereDateUploaded($value)
 */
class CustomerShippingAddress extends Model
{
	protected $table = 'CustomerShippingAddresses';

	public function scopeDivision($query, $division) {
		return $query->whereDivision($division);
	}
}
