<?php

namespace Hilco\Models;

use Debugbar;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Venturecraft\Revisionable\RevisionableTrait;

class WebSilo extends WebModel implements HasLandingPageInterface {
	protected $table = "WebSilos";
	protected $fillable = ['contactus_id', 'name', 'slug', 'webRoleIds', 'is_visible', 'is_default', 'detail', 'default_price_list', 'contact_phone', 'contact_email', 'weblandingpage_id'];
	protected $casts = [
	    'is_visible' => 'boolean'
	];

	public function webGroups() {
		return $this->belongsToMany(WebGroup::class, 'WebGroup_WebSilo', 'websilo_id', 'webgroup_id')->withPivot('display_order');
	}

    public function visibleWebGroups() {
        return $this->belongsToMany(WebGroup::class, 'WebGroup_WebSilo', 'websilo_id', 'webgroup_id')
            ->withPivot('display_order')
            ->visible()
            ->displayOrder()
        ;
    }

	public function contactUs() {
		return $this->belongsTo(WebContactUs::class, 'contactus_id', 'id');
	}

	public function webLinkCategories() {
		return $this->belongsToMany(WebCategory::class, 'WebLinkCategory_WebSilo', 'websilo_id', 'weblinkcategory_id');
	}

	public function webLinks() {
		return $this->belongsToMany(WebCategory::class, 'WebLink_WebSilo', 'websilo_id', 'weblink_id');
	}

	public function webUrls() {
	    return $this->hasMany(WebUrl::class, 'websilo_id', 'id');
    }

    public function parts() {
	    return $this->belongsToMany(Part::class, 'WebSilo_Part', 'websilo_id', 'part_id');
    }

	public function getFeaturedChildrenAttribute() {
        return $this->visibleWebGroups()->wherePivot('is_featured', 1)->get();
    }

    public function getChildrenAttribute() {
        return $this->visibleWebGroups()->get();
    }

    public function divisionRules() {
        return $this->belongsToMany(Division::class, 'WebSilo_Division', 'websilo_id', 'division_id');
    }

    public function customerCategorySummaryRules() {
        return $this->belongsToMany(CustomerCategorySummary::class, 'WebSilo_CustomerCategorySummary', 'websilo_id', 'customercategorysummary_id');
    }

    public function webCustomerTypeRules() {
        return $this->belongsToMany(WebCustomerType::class, 'WebSilo_WebCustomerType', 'websilo_id', 'webcustomertype_id');
    }

    public function getDivisionsAttribute() {
        return $this->divisionRules->pluck('id')->toArray();
    }

    public function setDivisionsAttribute($ids) {
        $this->divisionRules()->sync($ids);
    }

    public function getCustomerCategorySummariesAttribute() {
        return $this->customerCategorySummaryRules->pluck('id')->toArray();
    }

    public function setCustomerCategorySummariesAttribute($ids) {
        $this->customerCategorySummaryRules()->sync($ids);
    }

    public function getWebCustomerTypesAttribute() {
        return $this->webCustomerTypeRules->pluck('id')->toArray();
    }

    public function setWebCustomerTypesAttribute($ids) {
        $this->webCustomerTypeRules()->sync($ids);
    }

    public function getUrlsAttribute() {
        return $this->webUrls->pluck('id')->toArray();
    }

    public function setUrlsAttribute($ids) {
        $this->webUrls()->sync($ids);
    }

    /**
     * @return BelongsToMany $this
     */
    public function plants() {
        return $this->belongsToMany(Plant::class, 'Plant_WebSilo', 'websilo_id', 'plant_id')->withPivot('web_flags');
    }

    public function webLandingPage() {
        return $this->hasOne(WebLandingPage::class, 'id', 'weblandingpage_id');
    }

	public function scopeVisible(Builder $query) {
		return $query->where('WebSilos.is_visible', '1');
	}

	public function scopeCurrent(Builder $query) {
        $query->where('id', b2b()->activeWebSilo()->id);
    }

    public function getPriceListAttribute() {
        return 'Catalog';
    }

    public function scopeNavbarMenu(Builder $query) {
        return $query->with(['webGroups' => function ($query) {
            return $query->orderBy('pivot_display_order', 'asc')->orderBy('name', 'asc');
        }]);
    }

    public function slugUrl() {
        return route('silo.slug', [$this->slug]);
    }

    use HasAssets, HasSlug, HasLandingPage, RevisionableTrait;

    public function getParentRelationName() {
        return false;
    }
}
