<?php

namespace Hilco\Models;

use Auth;
use DB;
use HilcoB2B\M3Request;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Log;

/**
 * Hilco\Models\InventoryItem
 *
 * @property mixed $id
 * @property string $plant
 * @property mixed $plant_id
 * @property string $part_no
 * @property mixed $part_id
 * @property string $part_stat
 * @property string $part_src
 * @property string $part_type
 * @property boolean $part_taxable
 * @property boolean $kit_flag
 * @property boolean $on_bom
 * @property boolean $has_bom
 * @property integer $mfg_atp
 * @property float $first_avail_qty
 * @property string $first_avail_dt
 * @property float $max_avail_qty
 * @property string $max_avail_dt
 * @property string $date_created
 * @property string $date_modified
 * @property string $deleted_at
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePlant($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePlantId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartStat($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartSrc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartType($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem wherePartTaxable($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereKitFlag($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereOnBom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereHasBom($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMfgAtp($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereFirstAvailQty($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereFirstAvailDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMaxAvailQty($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereMaxAvailDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDeletedAt($value)
 * @mixin \Eloquent
 * @property integer $lot_control
 * @property string $date_uploaded
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereLotControl($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\InventoryItem whereDateUploaded($value)
 */
class InventoryItem extends Model
{
    protected $table = 'InventoryItems';
    const CREATED_AT = 'date_created';
    const UPDATED_AT = 'date_modified';
    protected $with = ['partBOMs.compPart.inventoryItems'];

    use \Hilco\SoftDeletes;

    public function partBOMs() {
        return $this->hasMany(PartBOM::class, 'main_part_id', 'part_id');
    }

    public function scopeInPlant(Builder $query, $plant) {
        return $query->where('plant', '=', $plant);
    }

    public function scopeWebFlagIn(Builder $query, $flags) {
        if (!is_array($flags)) $flags = [$flags];
        return $query->whereIn('web_flag', $flags);
    }

    public function scopeAvailableInPlant(Builder $query, $activePlants = false) {
        if ($activePlants === false) $activePlants = b2b()->activePlants();
        $query->where(function ($query) use ($activePlants) {
            foreach ($activePlants as $activePlant) {
                if (!strlen($activePlant->plant)) continue;
                $query->orWhere(function ($query) use ($activePlant) {
                    return $query
                        ->where('plant', $activePlant->plant)
                        ->whereIn('web_flag', config('hilco.inventoryItemWebFlags'))
                        ->where(function ($query) {
                            $query
                                ->where('part_stat', '!=', 'Phase-out')
                                ->orWhere('max_avail_qty', '>', '0')
                            ;
                        })
                    ;
                });
            }
            return $query;
        });
        return $query;
    }

    public function scopeInSilo(Builder $query, $plant = false) {
        if ($plant === false) $plant = b2b()->activePlant();
        $query->where(function ($query) use ($plant) {
            return $query
                ->where('plant', array_get($plant, 'plant'))
                ->whereIn('web_flag', config('hilco.inventoryItemWebFlags'))
                ->where(function ($query) {
                    $query
                        ->where('part_stat', '!=', 'Phase-out')
                        ->orWhere('max_avail_qty', '>', '0')
                    ;
                })
            ;
        });
        return $query;
    }

    public function scopeIsValid(Builder $query) {
        $query->where('part_stat', '!=', 'Phase-out')->orWhere('max_avail_qty', '>', '0');
    }

    public function getIsValidAttribute() {
        return $this->part_stat != 'Phase-out' || $this->max_avail_qty > 0;
    }

    public function getInStockAttribute() {
        $shippingAddress = b2b()->activeShippingAddress();
        if(!is_null($shippingAddress) && $shippingAddress->def_ship_from == 'LASVEGAS'){
            $activePlantNames = [];
            foreach (Plant::whereIn('plant', ['PLAINVILLE', 'LASVEGAS'])->get() as $plant){
                $activePlantNames [] = $plant->plant;
            }
        }
        else {
            $activePlants = b2b()->activePlants();
            $activePlantNames = $activePlants->pluck('plant')->toArray();
        }

        if (!(in_array($this->plant, $activePlantNames) && in_array($this->web_flag, config('hilco.inventoryItemWebFlags')))) return false;
//        if (!($this->plant == array_get($activePlant, 'plant') && in_array($this->web_flag, config('hilco.inventoryItemWebFlags')))) return false;

        dd($this);
        if ($this->kit_flag) {
            foreach ($this->partBOMs as $bom) {
                foreach ($bom->compPart->inventoryItems as $bomInventory) {
                    if ($bomInventory->in_stock) return true;
                }
            }
            return false;
        } else {
            $partNum = DB::table('LegacyParts')->where('oldpart_number', '=', $this->part_no)->first();
            if(empty($partNum)){
                $partNum = $this->part_no;
            }else{
                $partNum = $partNum->newpart_number;
            }
            $atp = self::getATP($partNum, Auth::user() ? $shippingAddress->def_ship_from : null);
            return !empty($atp) ? ($atp > 0) : ($atp === false ? $atp : null);
        }
    }

    public static function getATP($partNumber, $warehouse){
        $client = new M3Request();
        if(empty($client->client)){
            Log::error('Exception Caught while performing ' . __FUNCTION__ . ': Guzzle Http Client does not exist. Base URI may be missing!');
            return null;
        }else{
            $client = $client->client;
        }
        $response = json_decode($client->get('v4/' . __FUNCTION__, ['query' => ['requestFrom' => 'b2b', 'item_number' => $partNumber, 'warehouse' => $warehouse], 'headers' => ['Accept' => 'application/json']])->getBody()->getContents(), true);
        if(count($response['details']) == 1){
            Log::error('Exception Caught while performing ' . __FUNCTION__ . ': ' . $response['details']);
            return null;
        }else if(array_has($response['details'], 'MIRecord')){
            $results = $response['details']['MIRecord'][0]['NameValue'];
            foreach($results as $result){
                if($result['Name'] == 'AVTQ'){
                    return round(trim($result['Value'], ' '));
                }
            }
        }else{
            Log::error('Exception Caught while performing ' . __FUNCTION__ . ': ' . $response['details']['Message']);
            return null;
        }
    }
}

