<?php

namespace Hilco\Models;


/**
 * Hilco\Models\OrderDiscountLine
 *
 * @property mixed $id
 * @property string $discount_code
 * @property string $discount_desc
 * @property float $discount_amount
 * @property float $discount_percent
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property boolean $is_m3_discount
 * @property string $reason
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDiscountCode($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDiscountDesc($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDiscountAmount($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property mixed $salesorder_id
 * @property int $m3_index
 * @property mixed $salesorderline_id
 * @property integer $line_number
 * @property integer $line_order
 * @property string $line_suborder
 * @property integer $commit_sequence
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereSalesorderId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereLineNumber($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereLineOrder($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderDiscountLine whereLineSuborder($value)
 */
class OrderDiscountLine extends UuidModel
{
    protected $table = 'SalesOrderDiscLines';

    public function isM3Discount(){
        if($is_m3_discount){
            return true;
        }else{
            return false;
        }
    }
    
}
