<?php
/**
 * Created by PhpStorm.
 * User: steven
 * Date: 7/29/19
 * Time: 10:25 AM
 */

namespace Hilco\RateShopHelper;

/**
 * Class RateReturn
 * @package Hilco\RateShopHelper
 *
 * Wrapper class to hold an individual rate return as it comes back from us from ProcessWeaver
 */
class RateReturn
{
    protected $carrier_name;
    protected $transitCode;
    protected $rate;
    protected $discountedRate;
    protected $deliveryDateTimeStamp;
    protected $deliveryDate;
    protected $deliveryTime;

    public function __construct(array $rateArray)
    {
        $this->carrier_name = array_get($rateArray, 'carrier_name');
        $this->transitCode = array_get($rateArray, 'transit_code');
        $this->rate = array_get($rateArray, 'rate');
        $this->discountedRate = array_get($rateArray, 'discounted_rate');
        $this->deliveryDateTimeStamp = array_get($rateArray, 'delivery_datetime');

        if($this->deliveryDateTimeStamp){
            $timestamp = strtotime($this->deliveryDateTimeStamp);
            $this->deliveryDate = date('Y-m-d', $timestamp);
            $this->deliveryTime = date('Gi.s', $timestamp);
        }

    }

    /**
     * @return mixed
     */
    public function getCarrierName()
    {
        return $this->carrier_name;
    }

    /**
     * @return false|string
     */
    public function getDeliveryDate()
    {
        return $this->deliveryDate;
    }

    /**
     * @return mixed
     */
    public function getDeliveryDateTimeStamp()
    {
        return $this->deliveryDateTimeStamp;
    }

    /**
     * @return false|string
     */
    public function getDeliveryTime()
    {
        return $this->deliveryTime;
    }

    /**
     * @return mixed
     */
    public function getDiscountedRate()
    {
        return $this->discountedRate;
    }

    /**
     * @return mixed
     */
    public function getRate()
    {
        return $this->rate;
    }

    /**
     * @return mixed
     */
    public function getTransitCode()
    {
        return $this->transitCode;
    }

    /**
     * @param mixed $carrier_name
     */
    public function setCarrierName($carrier_name)
    {
        $this->carrier_name = $carrier_name;
    }

    /**
     * @param false|string $deliveryDate
     */
    public function setDeliveryDate($deliveryDate)
    {
        $this->deliveryDate = $deliveryDate;
    }

    /**
     * @param mixed $deliveryDateTimeStamp
     */
    public function setDeliveryDateTimeStamp($deliveryDateTimeStamp)
    {
        $this->deliveryDateTimeStamp = $deliveryDateTimeStamp;
    }

    /**
     * @param false|string $deliveryTime
     */
    public function setDeliveryTime($deliveryTime)
    {
        $this->deliveryTime = $deliveryTime;
    }

    /**
     * @param mixed $discountedRate
     */
    public function setDiscountedRate($discountedRate)
    {
        $this->discountedRate = $discountedRate;
    }

    /**
     * @param mixed $rate
     */
    public function setRate($rate)
    {
        $this->rate = $rate;
    }

    /**
     * @param mixed $transitCode
     */
    public function setTransitCode($transitCode)
    {
        $this->transitCode = $transitCode;
    }
}