<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsTo;

/**
 * Hilco\Models\RewardsCustomer
 *
 * @property int $customer_id
 * @property Customer $customer
 */
class LegacyRewardsCustomer extends WebModel {
    protected $table = "LegacyRewardsCustomers";

    public function customer(): BelongsTo {
        return $this->belongsTo(Customer::class, "customer_id", "id");
    }
}