<?php
/**
 * Created by PhpStorm.
 * User: cbarranco
 * Date: 4/22/17
 * Time: 12:48 PM
 */

namespace Hilco\Shipments;

use Hilco\Models\Carrier;
use Hilco\Models\DeliveryMethod;
use Hilco\Models\DeliveryTerm;

class Rate {
    /**
     * @var string
     */
    protected $method;

    /**
     * @var string
     */
    protected $term;
    
    /**
     * @var float
     */
    protected $baseRate;

    /**
     * @var float
     */
    protected $discountAmount;

    /**
     * @var bool
     */
    protected $overrideText;

    /**
     * @var float
     */
    protected $taxAmount;

    /**
     * @var boolean
     */
    protected $isDefault;

    /**
     * @var bool
     */
    public $selected;

    /**
     * @var bool
     */
    protected $isFreightAccount;

    /**
     * @var bool
     */
    protected $isGermanDomestic;

    /**
     * Rate constructor.
     * @param string $method
     * @param string $term
     * @param float $baseRate
     * @param float $discountAmount
     * @param float $taxAmount
     * @param float $rate
     * @param bool $isDefault
     * @param bool $isFreightAccount
     */
    public function __construct($method, $term, $baseRate, $isDefault = false, $discountAmount = 0, $taxAmount = 0, $isFreightAccount = false, $isGermanDomestic = false) {
        $this->method = $method;
        $this->term = $term;
        $this->baseRate = $baseRate;
        $this->discountAmount = $discountAmount;
        $this->taxAmount = $taxAmount;
        $this->isDefault = $isDefault;
        $this->overrideText = false;
        $this->selected = false;
        $this->isFreightAccount = $isFreightAccount;
        $this->isGermanDomestic = $isGermanDomestic;
    }

    public static function getHandlingFee() {
        return config('rateshop.handling_fee');
    }

    public function setText($text) {
        $this->overrideText = $text;
    }

    public function code() {
        return isset($this->method) ? $this->method : -1;
    }

    public function isError() {
        return $this->code() === -1;
    }

    public function methodID(){
            return DeliveryMethod::where('delivery_method_code', '=', $this->method)->pluck('id')->first();
    }

    public function term() {
            return $this->term;
    }

    public function termID(){
            return DeliveryTerm::where('delivery_term_code', '=', $this->term)->pluck('id')->first();
    }

    public function rate() {
        if ($this->isError()) return 0;
        return $this->baseRate - $this->discountAmount + $this->taxAmount;
    }

    public function displayText() {
        if ($this->isError()) return trans('hilco::app.unable_to_calculate_shipping_rates');

        if ($this->overrideText) {
            $displayText = $this->overrideText;
        } else {
            $displayText = \Illuminate\Support\Arr::get($this->carrier, 'carrier_desc');
        }

        if ($this->isDefault) $displayText .= ' '.trans('hilco::app.default_parentheses');
        return $displayText;
    }

    public function method() {
        return $this->method;
    }

    public function isDefault() {
        return $this->isDefault;
    }

    public function isDiscounted() {
        return $this->discountAmount > 0;
    }

    public function discountAmount() {
        return $this->discountAmount;
    }

    public function taxAmount() {
        return $this->taxAmount;
    }

    public function baseRate() {
        return $this->baseRate;
    }

    public function isFreightAccount() {
        return $this->isFreightAccount;
    }

    public function isGermanDomestic() {
        return $this->isGermanDomestic;
    }
}