<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;

/**
 * M3 general object mapping
 * @property-read string $OBV1
 * @method static Builder byPriceListTable($priceListTable)
 */
class CROBJC extends Model {
    protected $table = "CROBJC";
    protected $connection = "hilco-pricelist";

    const PROGRAM = 'OIS831';
    const NUM_PRIORITY_LEVELS = 10; // PC0*, PC1*, PC2*, PC3*, etc
    const NUM_PC_RULES = 5; // PC*1, PC*2, PC*3, PC*4, PC*5

    /**
     * @return string
     */
    public function getPriceListTable() {
        return $this->OBV1;
    }

    /**
     * @param Builder $query
     * @param string $priceListTable
     * @return Builder
     */
    public function scopeByPriceListTable (Builder $query, string $priceListTable): Builder {
        $pgnm = self::PROGRAM;
        return $query->where('PGNM', "$pgnm")->where('OBV1', "$priceListTable");
    }

    /**
     * @param $rulesetNo
     * @param $ruleNo
     * @return string
     */
    public function getRule ($rulesetNo, $ruleNo): string {
        $pcCol = "PC$rulesetNo$ruleNo";
        return $this->$pcCol;
    }
}