<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class RateShopGroup extends Model {
	protected $table = "RateShopGroups";

    const CST_US_GROUP_CODE = "1";
    const CA_GROUP_CODE = "2";
    const B2B_US_GROUP_CODE = "3";
    const PUROLATOR_GROUP_CODE = "4";

	public function scopeGroupCode($query, $groupCode) {
	    return $query->where('group_code', '=', $groupCode);
    }

    public function carrier() {
	    return $this->belongsTo(Carrier::class, 'hilco_carrier_code', 'carrier_code');
    }
}
