<?php

namespace Hilco\Models;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;


/**
 * Hilco\Models\Customer
 *
 * @property integer $id
 * @property string $cust_no
 * @property string $cust_name
 * @property string $aff_cust_no
 * @property integer $aff_customer_id
 * @property string $aff_cust_name
 * @property string $addr_1
 * @property string $addr_2
 * @property string $addr_3
 * @property string $addr_4
 * @property string $addr_5
 * @property string $city
 * @property string $state
 * @property string $zip_postal
 * @property string $country
 * @property string $category
 * @property integer $customercategory_id
 * @property string $incept_dt
 * @property string $currency
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerSegment[] $segments
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Division[] $divisions
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerPhone[] $phones
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerEmail[] $emails
 * @property-read \Hilco\Models\CustomerCategory $customer_category
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerContact[] $contacts
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\CustomerDiscount[] $discounts
 * @property-read \Illuminate\Database\Eloquent\Collection|\Hilco\Models\Order[] $orders
 * @property-read mixed $id_string
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAffCustNo($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAffCustomerId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAffCustName($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr1($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr2($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr3($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr4($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereAddr5($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCity($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereState($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereZipPostal($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCountry($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCategory($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCustomercategoryId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereInceptDt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereCurrency($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer whereDeletedAt($value)
 * @mixin \Eloquent
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer affiliateSales()
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\Customer categorySales($category, $min, $max)
 */
class Customer extends Model
{
	protected $table = 'Customers';

	public function webUser()
	{
		return $this->hasOne(WebUser::class, 'customer_id');
	}

	public function shippingAddresses() {
		return $this->hasMany(CustomerShippingAddress::class, 'cust_no', 'cust_no')->division('HILCO-US');
	}
	public static $priority = [
		'A'	=> [
			'from' => 2000,
			'to'   => 9999999
		],
		'B'	=> [
			'from' => 1000,
			'to'   => 1999
		],
		'C'	=> [
			'from' => 400,
			'to'   => 999
		],
		'D'	=> [
			'from' => 0,
			'to'   => 399
		]
	];

//	public function user()
//	{
//		return $this->hasOne(User::class, 'customer_id');
//	}

	public function segments()
	{
		return $this->hasMany(CustomerSegment::class);
	}

	public function billtoSegments()
	{
		return $this->hasMany(CustomerSegment::class,'billto_customer_id');
	}

	public function divisions()
	{
		return $this->belongsToMany(Division::class, 'CustomerSegments', 'customer_id', 'division_id');
	}

	public function phones()
	{
		return $this->hasMany(CustomerPhone::class);
	}

	public function emails()
	{
		return $this->hasMany(CustomerEmail::class);
	}

	public function customer_category() {
	    return $this->customerCategory;
    }

	public function customerCategory()
	{
		return $this->belongsTo(CustomerCategory::class, 'customercategory_id');
	}

	public function contacts()
	{
		return $this->hasMany(CustomerContact::class);
	}

	public function discounts()
	{
		return $this->hasMany(CustomerDiscount::class);
	}

	public function customerStateTax(){
		return $this->belongsTo(StateTax::class,'state','state')
			->where(function($query){
				$query->where(function($query){
					return $query->where('effective_date','<=', date('Y-m-d',time()))
						->where('expiration_date','>=', date('Y-m-d',time()));
				})
					->orWhere('expiration_date', '000-00-00');
			});
	}

	public function customerVATTax(){

	}

	public function orders()
	{
		return $this->hasMany(Order::class, 'soldto_customer_id');
	}

	public function salesStats()
	{
		return $this->hasMany(CustomerSalesStats::class, 'customer_id');
	}

	public function stateTax() {
		return StateTax::where("state", $this->state)->inEffect()->first();
	}

	public function scopeWithEmails($query) {
		return $query->addSelect('email_raw', 'good_email', 'email_note', 'email_news', 'email_sales', 'email_ship')
			->join('CustomerEmails', 'Customers.id', '=', 'CustomerEmails.customer_id')
			;
	}

}
