<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

/**
 * Hilco\Models\StagedOrderDiscLine
 * @property integer id
 * @property integer stagedorderline_id
 * @property string discount_code
 * @property string discount_desc
 * @property float discount_amount
 * @property float discount_percent
 * @property integer m3_index
 * @property mixed salesorderdiscline_id
 * @property OrderDiscountLine salesOrderDiscLine
 * @property Collection|StagedOneOffLineDiscount[] stagedOneOffLineDiscounts
 * @property StagedOrderLine stagedOrderLine
 */
class StagedOrderDiscLine extends StagingModel {
    protected $table = "StagedOrderDiscLines";

    const ONE_OFF = "One-Off";

    /**
     * @return float
     */
    public function getDiscountAmount(): float {
        return $this->discount_amount;
    }

    /**
     * @return string
     */
    public function getDiscountCode(): string {
        return $this->discount_code;
    }

    /**
     * @return string
     */
    public function getDiscountDesc(): string {
        return $this->discount_desc;
    }

    /**
     * @return float
     */
    public function getDiscountPercent(): float {
        return $this->discount_percent;
    }

    public function getBucketNumber() {
        return $this->m3_index;
    }

    /**
     * @return bool
     */
    public function isOneOff(): bool {
        return $this->discount_code === self::ONE_OFF;
    }

    /**
     * @return BelongsTo
     */
    public function salesOrderDiscLine(): BelongsTo {
        return $this->belongsTo(OrderDiscountLine::class, "salesorderdiscline_id", "id");
    }

    /**
     * @return HasMany
     */
    public function stagedOneOffLineDiscounts(): HasMany {
        return $this->hasMany(StagedOneOffLineDiscount::class, "stagedorderdiscline_id", "id");
    }

    /**
     * @return BelongsTo
     */
    public function stagedOrderLine(): BelongsTo {
        return $this->belongsTo(StagedOrderLine::class, "stagedorderline_id", "id");
    }
}