<?php

namespace Hilco\Models;


use Illuminate\Database\Query\Builder;
use Throwable;

/**
 * Hilco\Models\OrderDiscountLine
 *
 * @property mixed $id
 * @property string $discount_code
 * @property string $discount_desc
 * @property float $discount_amount
 * @property float $discount_percent
 * @property string $date_created
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property boolean $is_m3_discount
 * @property string $reason
 * @property-read mixed $id_string
 * @method static Builder|OrderDiscountLine whereId($value)
 * @method static Builder|OrderDiscountLine whereDiscountCode($value)
 * @method static Builder|OrderDiscountLine whereDiscountDesc($value)
 * @method static Builder|OrderDiscountLine whereDiscountAmount($value)
 * @method static Builder|OrderDiscountLine whereDateCreated($value)
 * @method static Builder|OrderDiscountLine whereDateModified($value)
 * @method static Builder|OrderDiscountLine whereDateUploaded($value)
 * @method static Builder|OrderDiscountLine whereDeletedAt($value)
 * @mixin \Eloquent
 * @property mixed $salesorder_id
 * @property int $m3_index
 * @property mixed $salesorderline_id
 * @property integer $line_number
 * @property integer $line_order
 * @property string $line_suborder
 * @property integer $commit_sequence
 * @method static Builder|OrderDiscountLine whereSalesorderId($value)
 * @method static Builder|OrderDiscountLine whereLineNumber($value)
 * @method static Builder|OrderDiscountLine whereLineOrder($value)
 * @method static Builder|OrderDiscountLine whereLineSuborder($value)
 */
class OrderDiscountLine extends UuidModel {
    protected $table = 'SalesOrderDiscLines';
    protected $fillable = [
        'id', 'salesorder_id',
        'discount_code', 'discount_desc', 'discount_amount', 'discount_percent',
        'm3_index', 'salesorderline_id',
        'commit_sequence',
    ];

    /**
     * @param StagedOrderDiscLine $stagedOrderDiscLine
     * @param int $commit_sequence
     * @return OrderDiscountLine
     * @throws Throwable
     */
    public static function createFromStaged (StagedOrderDiscLine $stagedOrderDiscLine, int $commit_sequence): OrderDiscountLine {
        $stagedOrderLine = $stagedOrderDiscLine->stagedOrderLine;
        $stagedOrder = $stagedOrderLine->stagedOrder;
        $salesOrder = $stagedOrder->salesOrder;
        $salesOrderLine = $stagedOrderLine->salesOrderLine;
        $salesOrderDiscLine = new OrderDiscountLine([
            'id' => generateUUID(),
            'salesorder_id' => $salesOrder->id,
            'discount_code' => $stagedOrderDiscLine->getDiscountCode(),
            'discount_desc' => $stagedOrderDiscLine->getDiscountDesc(),
            'discount_amount' => $stagedOrderDiscLine->getDiscountAmount(),
            'discount_percent' => $stagedOrderDiscLine->getDiscountPercent(),
            'm3_index' => $stagedOrderDiscLine->getBucketNumber(),
            'salesorderline_id' => $salesOrderLine->id,
            'commit_sequence' => $commit_sequence,
        ]);
        $salesOrderDiscLine->saveOrFail();
        return $salesOrderDiscLine;
    }
    
}
