<?php

namespace Hilco\M3Helper\ResponseModels;

/**
 * Class NameValue
 * @package Hilco\M3Helper\ResponseModels
 */
class NameValue {
    /**
     * @var array
     */
    private $nameValuePairs;

    /**
     * NameValue constructor.
     * @param $nameValueArray
     */
    public function __construct ($nameValueArray) {
        foreach ($nameValueArray as $nameValue) {
            $this->nameValuePairs[$nameValue['Name']] = trim($nameValue['Value']);
        }
    }

    /**
     * @return array
     */
    public function getNameValuePairs() {
        return $this->nameValuePairs;
    }

    /**
     * @return string
     */
    public function __toString() {
        return json_encode($this->nameValuePairs);
    }
}