<?php

namespace Hilco\M3Helper\ResponseModels;

/**
 * Class MIRecordResponseModel
 * @package Hilco\M3Helper\ResponseModels
 */
class MIRecordResponseModel extends GenericM3ResponseModel {
    /**
     * @var string
     */
    private $program;

    /**
     * @var string
     */
    private $transaction;

    /**
     * @var
     */
    private $metadata;

    /**
     * @var MIRecord
     */
    private $miRecord;

    /**
     * MIRecordResponseModel constructor.
     * @param $responseObj
     */
    public function __construct($responseObj) {
        $this->program = $responseObj['Program'];
        $this->transaction = $responseObj['Transaction'];
        $this->metadata = $responseObj['Metadata'];
        $this->miRecord = new MIRecord($responseObj['MIRecord']);
        parent::__construct($responseObj);
    }

    /**
     * @return MIRecord
     */
    public function getMIRecord() {
        return $this->miRecord;
    }

    /**
     * @return string
     */
    public function __toString() {
        return json_encode(
            [
                'Program' => $this->program,
                'Transaction' => $this->transaction,
                'Metadata' => $this->metadata,
                'MIRecord' => $this->miRecord
            ]
        );
    }
}