<?php

namespace Hilco\M3Helper\ResponseModels;

/**
 * Class MIRecord
 * @package Hilco\M3Helper\ResponseModels
 */
class MIRecord {
    /**
     * @var NameValue
     */
    private $nameValue;

    /**
     * @var int
     */
    private $rowIndex;

    /**
     * MIRecord constructor.
     * @param $recordObj
     */
    public function __construct($recordObj) {
        $this->nameValue = new NameValue($recordObj[0]['NameValue']);
        $this->rowIndex = $recordObj[0]['RowIndex'];
    }

    /**
     * @return NameValue
     */
    public function getNameValue() {
        return $this->nameValue;
    }

    /**
     * @param $name
     * @return mixed
     */
    public function getValueForName ($name) {
        $nameValuePairs = $this->nameValue->getNameValuePairs();
        return $nameValuePairs[$name];
    }

    /**
     * @return string
     */
    public function __toString() {
        return json_encode(
            [
                'NameValue' => $this->nameValue,
                'RowIndex' => $this->rowIndex
            ]
        );
    }
}