<?php

namespace Hilco\M3Helper\ResponseModels;

/**
 * Class GenericM3ResponseModel
 * @package Hilco\M3Helper\ResponseModels
 */
class GenericM3ResponseModel {
    /**
     * @var array
     */
    protected $responseObj;

    /**
     * GenericM3ResponseModel constructor.
     * @param $responseObj
     */
    public function __construct($responseObj) {
        $this->responseObj = $responseObj;
    }

    /**
     * @param $responseObj
     * @return ErrorResponseModel|GenericM3ResponseModel|MessageResponseModel|MIRecordResponseModel
     */
    public static function createResponseModel($responseObj) {
        if (array_has($responseObj, 'MIRecord')) {
            return new MIRecordResponseModel($responseObj);
        } else if (array_has($responseObj, 'Message')) {
            return new MessageResponseModel($responseObj);
        } else if (array_has($responseObj, 'Error')) {
            return new ErrorResponseModel($responseObj);
        } else {
            return new GenericM3ResponseModel($responseObj);
        }
    }
}