<?php

namespace Hilco\M3Helper;

/**
 * Class M3RequestOptions
 * @package Hilco\M3Helper
 */
class M3RequestOptions {

    /**
     * @var array
     */
    private $headers;

    /**
     * @var int
     */
    private $connectTimeout;

    /**
     * @var int
     */
    private $timeout;

    /**
     * M3RequestOptions constructor.
     * @param $headers
     * @param int $connectTimeout
     * @param int $timeout
     */
    public function __construct($headers, $connectTimeout = 5, $timeout = 5) {
        $this->headers = $headers;
        $this->connectTimeout = $connectTimeout;
        $this->timeout = $timeout;
    }

    /**
     * Get the request options as an associative array to be used in a Guzzle client GET request
     * @return array
     */
    public function getOptionsForGuzzleRequest() {
        return [
            'headers' => $this->headers,
            'connect_timeout' => $this->connectTimeout,
            'timeout' => $this->timeout,
        ];
    }

    /**
     * Get the options formatted for use with curl_setopt_array()
     * @return array
     */
    public function getOptionsForCurlRequest() {
        return array(
            CURLOPT_HTTPHEADER      => self::getHeadersForCurl(),
            CURLOPT_CONNECTTIMEOUT  => self::getConnectTimeout(),
            CURLOPT_TIMEOUT         => self::getTimeout(),
            CURLOPT_RETURNTRANSFER  => true
        );
    }

    /**
     * @return array
     */
    public function getHeaders() {
        return $this->headers;
    }

    /**
     * curl_setopt() only accepts the format [ '<key>: <value>' , '<key>: <value>'...]
     * when using CURLOPT_HTTPHEADER to set headers for a cURL request
     * @return array
     */
    private function getHeadersForCurl() {
        $headerArr = [];
        $assocArr = $this->headers;
        foreach ($assocArr as $key => $value) {
            $headerArr[] = $key . ': ' . $value;
        }
        return $headerArr;
    }

    /**
     * @return int
     */
    public function getConnectTimeout() {
        return $this->connectTimeout;
    }

    /**
     * @return int
     */
    public function getTimeout() {
        return $this->timeout;
    }
}