<?php

namespace Hilco\Models;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\Relations\Relation;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use LogicException;

/**
 * Class Promotion
 * @package Hilco\Models
 *
 * @method static Builder active()
 */
class Promotion extends WebModel
{
    protected $table = 'Promotions';
    protected $fillable = ['name', 'start_date', 'end_date', 'enabled', 'cart_header', 'checkout_header', 'cart_header_title', 'checkout_header_title', 'commit_sequence'];
    protected $casts = [
        'enabled' => 'boolean',
//        'start_date' => 'date',
//        'end_date' => 'datetime',
    ];

    protected static $morphMap = [
        'customerTrigger' => PromotionCustomerTrigger::class,
        'currentOrderTrigger' => PromotionCurrentOrderTrigger::class,
        'customerCategoryTrigger' => PromotionCustomerCategoryTrigger::class,
        'itemDiscountAction' => PromotionItemDiscountAction::class,
        'rewardsTierTrigger' => PromotionRewardsTierTrigger::class,
        'salesRepTrigger' => PromotionSalesRepTrigger::class,
        'jobsonProfileTrigger' => PromotionJobsonProfileTrigger::class,
        'shippingDiscountAction' => PromotionShippingDiscountAction::class,
        'carrierCodeAction' => PromotionCarrierCodeAction::class,
        'carrierAccountAction' => PromotionCarrierAccountAction::class,
        'internalCommentAction' => PromotionInternalCommentAction::class
    ];

    public function triggers() {
        return $this->hasMany(PromotionTrigger::class);
    }

//    public function actionsOfType($action_type) {
//        return $this->hasMany(PromotionAction::class)->where('action_type', $action_type);
//    }

    public function actions() {
        return $this->hasMany(PromotionAction::class);
    }

    public function itemDiscountActions() {
        return $this->morphedByMany(PromotionItemDiscountAction::class, 'action', 'PromotionActions', 'promotion_id')
            ->withPivot(['sequence'])
            ;
    }

    public function getAllActionsAttribute() {
        return collect([
            $this->itemDiscountActions->flatten(),
        ])->flatten();
    }

//    public static function getTriggerClassFromType($triggerType) {
//    return array_get(Relation::morphMap(), $triggerType, $triggerType);
//}

//    public static function createTriggerFromType($triggerType) {
//        $class = self::getTriggerClassFromType($triggerType);
//        return new $class;
//    }

//    public static function findTriggerFromType($triggerType, $triggerId) {
//        $class = self::getTriggerClassFromType($triggerType);
//        return $class::find($triggerId);
//    }

//    public function getTriggerRelationFromType($triggerType) {
//        $relationName = $triggerType . 's';
//        $relation = $this->$relationName();
//        return $relation;
//    }

    public static function getActionClassFromType($actionType) {
        return array_get(Relation::morphMap(), $actionType, $actionType);
    }

    public static function createActionFromType($actionType) {
        $class = self::getActionClassFromType($actionType);
        return new $class;
    }

//    public static function findActionFromType($actionType, $actionId) {
//        $class = self::getActionClassFromType($actionType);
//        return $class::find($actionId);
//    }

    public function getActionRelationFromType($actionType) {
        $relationName = $actionType . 's';
        $relation = $this->$relationName();
        return $relation;
    }
    
    public function scopeActive($query) {
        $query
            ->where('enabled', 1)
            ->where(function ($query) {
                return $query
                    ->where('start_date', '=', '0000-00-00 00:00:00')
                    ->orWhere('start_date', '<=', DB::raw('NOW()'))
                    ;
            })
            ->where(function ($query) {
                return $query
                    ->where('end_date', '=', '0000-00-00 00:00:00')
                    ->orWhere('end_date', '>=', DB::raw('NOW()'))
                    ;
            })
        ;
    }

    public static function getMorphMap() {
        return self::$morphMap;
    }

    public static function getActivePromotions() {
        return Promotion::active()->get();
    }

    public function getStartDateDatepickerAttribute() {
        $date = ($this->attributes['start_date'] == '0000-00-00') ? Carbon::create(2017, 1, 1) : Carbon::createFromFormat('Y-m-d', $this->attributes['start_date']);

        return $date->format('Y-m-d');
    }

    public function getEndDateDatepickerAttribute() {
        $date = ($this->attributes['end_date'] == '0000-00-00') ? Carbon::now()->addYear(1) : Carbon::createFromFormat('Y-m-d', $this->attributes['end_date']);

        return $date->format('Y-m-d');
    }

    use HasCommitSequence;
}
