<?php

namespace Hilco\Models;


/**
 * Hilco\Models\OrderAttnLine
 *
 * @property mixed $id
 * @property-read mixed $id_string
 * @property mixed $salesorder_id
 * @property string $date_created
 * @property string $status
 * @property string $auth_reference_num
 * @property string $authorization_code
 * @property string $last_four_digits
 * @property string $authorized_amount
 * @property string $date_authorized
 * @property string $origin
 * @property string $date_modified
 * @property string $date_uploaded
 * @property string $deleted_at
 * @property string $onetime_auth
 * @property string $void_code
 * @property string $void_reference_num
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereId($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDateCreated($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDateModified($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDateUploaded($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereDeletedAt($value)
 * @method static \Illuminate\Database\Query\Builder|\Hilco\Models\OrderAttnLine whereSalesorderId($value)
 * @mixin \Eloquent
 */
class CreditCardAuthorization extends UuidModel
{
    protected $table = 'CreditCardAuthorizations';

    public function salesOrder() {
        return $this->belongsTo(Order::class, 'salesorder_id', 'id');
    }
}
