<?php

namespace Hilco\Models;

use DB;
use Hilco\Models\SelectsRelatedCount;

/**
 * Class WebFamily_WebCollection
 * @package Hilco\Models
 * @property int $webfamily_id
 * @property int $webcollection_id
 * @property bool $is_featured
 * @property int $display_order
 */
class WebFamily_WebCollection extends WebModel {
    protected $table = 'WebFamily_WebCollection';
    protected $fillable = ['webfamily_id', 'webcollection_id', 'is_featured', 'display_order', 'commit_sequence'];

    public static function maxCommit(): int {
        return WebFamily_WebCollection::withTrashed()->max("commit_sequence");
    }

    public static function nextCommit(): int {
        return WebFamily_WebCollection::maxCommit() + 1;
    }

    public static function createWebFamilyWebCollection (array $wfwcData) {
        if (! isset($wfwcData['commit_sequence'])) {
            $wfwcData['commit_sequence'] = WebFamily_WebCollection::nextCommit();
        }
        return WebFamily_WebCollection::create($wfwcData);
    }

    public static function deleteWebFamilyWebCollection ($id) {
        WebFamily_WebCollection::find($id)->delete();
        WebFamily_WebCollection::onlyTrashed()->find($id)->update([
            'commit_sequence' => WebFamily_WebCollection::nextCommit()
        ]);
    }

    public function webFamily() {
        return $this->belongsTo(WebFamily::class, 'webfamily_id', 'id');
    }

    public function webCollection() {
        return $this->belongsTo(WebCollection::class, 'webcollection_id', 'id');
    }

    public function scopeByWFWC ($query, $webfamily_id, $webcollection_id) {
        return $query->where('webfamily_id', $webfamily_id)->where('webcollection_id', $webcollection_id);
    }
}
