<?php

namespace Hilco;

use Hilco\Models\Customer;
use Hilco\Models\Part;
use Hilco\Models\ProductCategoryGroup;
use Hilco\Models\WebGroup;

class RewardsHelper {
//    const ELIGIBLE = 'eligible';
//    const ACCOUNT_NOT_DIRECT_BILL = 'accountNotDirectBilling';
//    const AFFILIATE_NOT_DIRECT_BILL = 'affiliateNotDirectBilling';
//    const INVALID_CUSTOMER_CATEGORY = 'invalidCustomerCategory';
//    const EXCLUDED_MEMBER_GROUP = 'excludedMemberGroup';
//    const ALREADY_REGISTERED = 'registered';

    public function tierMap($id = false) {
        if ($id === false) return config('rewards.tierMap');
        return config("rewards.tierMap.$id", $id);
    }

    public function isEligible(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;
        $validCustomerCategory = in_array($customer->customercategory_id, config('rewards.eligibleCustomerCategoryIds', []));
        $validMemberGroup = !in_array($customer->member_group, config('rewards.eligibleCustomerCategoryIds', []));
        $validBilling = $customer->billsDirect;
        $validPriceList = in_array($customer->activeSegment->def_price_list, config('rewards.eligiblePriceLists', []));
        $validCurrency = in_array($customer->currency, config('rewards.eligibleCurrencyCodes', []));

        $validAffiliates = true;
        foreach ($customer->affiliateCustomer->affiliateChildren as $affiliate) {
            if (!$affiliate->billsDirect) $validAffiliates = false;
        }

        return ($validCustomerCategory && $validMemberGroup && $validBilling && $validAffiliates && $validPriceList);
    }

    public function isRegistered(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        $registration = $customer->rewardsRegistration;
        return !is_null($registration);
    }

    public function isQualified(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;
        $tier = $customer->rewardsTier;

        return is_null($tier) ? false : $tier->tier > 1;
    }

    public function qualifyingCategories(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        return $customer->rewardsTier->category_mix;
    }

    public function totalSpending(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        return $customer->rewardsTier->total_spending;
    }

    public function tier(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        $rewardsTier = $customer->rewardsTier;

        return is_null($rewardsTier) ? 0 : $rewardsTier->tier;
    }

    public function tierName(Customer $customer = null) {
        return $this->tierMap($this->tier($customer));
    }

    public function joinDate(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        return $customer->rewardsTier->date_created->toDateString();
    }

    public function discountForPart($partId, Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        $part = ($partId instanceof Part) ? $partId : Part::find($partId);
        $groupName = $part->productFamily->productCategory->productCategoryGroup->product_category_group;
        $currentTier = $this->tier($customer);
        $discount = config("rewards.productCategoryGroups.$groupName.discountPercentByTier.$currentTier", 0);
        return $discount;
    }

    public function calculateUpgrade($currentOrderSpending, Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        $status = $customer->rewardsStatus()->with('productCategoryGroup')->get();

        $currentTotal = $newTotal = $currentMix = $newMix = 0;
        $newSpending = collect();

        foreach ($status as $group) {
            $currentTotal += $group->spending;
            if ($group->spending >= 200) $currentMix++;

            $productCategoryGroupName = $group['productCategoryGroup']['product_category_group'];

            $groupTotalAfterOrder = ($group->spending + (float)array_get($currentOrderSpending, $productCategoryGroupName, 0));
            $newTotal += $groupTotalAfterOrder;
            if ($groupTotalAfterOrder >= 200) $newMix++;

            $newGroup = [
                'spending_before' => $group->spending,
                'spending_after' => $groupTotalAfterOrder,
                'qualifying_before' => $group->qualifying,
                'qualifying_after' => ($groupTotalAfterOrder >= 200),
                'product_category_group' => $productCategoryGroupName,
            ];

            $newSpending->put($group['productcategorygroup_id'], $newGroup);
        }



        return $newSpending;
    }

    public function calculateTier($spending, $categories, Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;


    }

    public function productCategoryGroups(Customer $customer = null) {
        if (is_null($customer)) $customer = auth()->user()->activeCustomer;

        $groupsConfig = config('rewards.productCategoryGroups');
        $map = collect();
        foreach ($groupsConfig as $name => $info) {
            $map->put($info['webGroupSlug'], $name);
        }

        $status = $customer->rewardsStatus;
        $groups = ProductCategoryGroup::orderBy('product_category_group')->get()->keyBy('id');
        $webGroups = WebGroup::whereIn('slug', $map->keys())->get();

        $data = collect();
        foreach ($webGroups as $webGroup) {
            $groupName = $map[$webGroup->slug];
            $group = $groups->where('product_category_group', $groupName)->first();
            if (is_null($group)) continue;
            $theStatus = $status->where('productcategorygroup_id', $group->id)->first();
            if (is_null($theStatus)) continue;
            $theStatus['displayName'] = $webGroup->name;
//            $theStatus['product_category_group'] = $groupName;
            $theStatus['webGroupId'] = $webGroup->id;
            $theStatus['webGroupSlug'] = $webGroup->slug;
            $theStatus['spendingPercent'] = 100 * (min(200, $theStatus['spending']) / 200);
            $theStatus['discounts'] = array_get($groupsConfig, "$groupName.discountPercentByTier");
            $data->put($group->id, $theStatus);
        }

        return $data;
    }

    public function info(Customer $customer) {
        $productCategoryGroups = ProductCategoryGroup::get()->keyBy('id');
        $tierLevel = 0;
        $tierName = rewards()->tierMap(0);

        $registration = $customer->rewardsRegistration;
        $isRegistered = !is_null($registration);

        $rewardsStatus = $customer->rewardsStatus;
        if (!is_null($rewardsStatus)) {
            $spending = $rewardsStatus;
        } else {
            $spending = $productCategoryGroups->map(function ($item) {
                $item->spending = 0;
                $item->qualifying = 0;
            });
        }

        $rewardsTier = $customer->rewardsTier;
        if (!is_null($rewardsTier)) {
            $tierLevel = $rewardsTier->tier;
            $tierName = rewards()->tierMap($rewardsTier->tier);
        }

        return [
            'tierLevel' => $tierLevel,
            'tierName' => $tierName,
            'registered' => $isRegistered,
            'eligible' => $customer->rewardsEligibility == Customer::REWARDS_ELIGIBLE,
            'qualified' => $tierLevel > 1,
            'spending' => $spending,
        ];
    }
}