<?php

namespace Hilco\Models;
use DB;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Collection;

class RateShopGroup extends Model {
	protected $table = "NewRateShopGroups";

	public function scopeGroupCode($query, $groupCode) {
	    return $query->where('group_code', '=', $groupCode);
    }

    public function carrier() {
	    return $this->belongsTo(Carrier::class, 'hilco_carrier_code', 'carrier_code');
    }
}
