@if(auth()->user())
<div class="col-md-6">
    <div class="panel panel-info">
        <div class="panel-heading">
            <h3 class="panel-title text-center">@lang('app.rewards_status')</h3>
        </div>
        <div class="panel-body" style="height: 280px">
            <div class="h4 text-center">
                @lang('app.your_hilco_vision_loyalty_rewards_level_is')
            </div>
            <div class="rewardsBar">
                <div class="one">@lang('app.one_caps')</div>
                <div class="bronze">@lang('app.bronze_caps')</div>
                <div class="silver">@lang('app.silver_caps')</div>
                <div class="gold active">@lang('app.gold_caps')</div>
                <div class="one platinum">@lang('app.platinum_caps')</div>
                <div class="clearfix"></div>
            </div>
            <br>
            <div>
                <div class="pull-right h3 nomargin">@lang('app.purchase_amount_example')</div>
                <p>@lang('app.last_12_months_qualifying_purchases') </p>
            </div>
            <div>
                <div class="pull-right h3 nomargin">3</div>
                <p>@lang('app.last_12_months_qualified_categories') </p>
            </div>
            <div class="text-info">@lang('app.hilco_vision_loyalty_rewards_rogram_member_since', ['date' => '8/20/16'])</div>
            <a href="#" class="btn btn-info">@lang('app.details')</a>
        </div>
    </div>
</div>
<div class="col-md-6">
    <div class="panel panel-info">
        <div class="panel-heading">
            <h3 class="panel-title text-center">@lang('app.recent_orders')</h3>
        </div>
        <div class="panel-body" style="height: 280px">
            <table class="table table-condensed">
                <thead>
                <tr>
                    <th>@lang('app.order_hashtag')</th>
                    <th>@lang('app.date')</th>
                    <th>@lang('app.quantity_short_dot')</th>
                    <th>@lang('app.status')</th>
                </tr>
                </thead>
                <tbody>
                @foreach($lastOrders as $order)
                    <tr>
                        <td>{{ $order->hilco_order_number }}</td>
                        <td>{{ $order->order_date }}</td>
                        <td>6</td>
                        <td>{{ $order->order_status }}</td>
                    </tr>
                @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@push('styles')
<style type="text/css">
    .rewardsBar {
        width: 100%;
        padding-bottom: 10px;
    }
    .rewardsBar .one,
    .rewardsBar .bronze,
    .rewardsBar .silver,
    .rewardsBar .gold,
    .rewardsBar .platinum {
        width: 20%;
        float: left;
        text-align: center;
        margin-top: 18px;
        padding: 5px;
        vertical-align: bottom;
    }
    .rewardsBar .one {
        background-color: green;
        color: white;
    }
    .rewardsBar .bronze {
        background-color: darkred;
        color: white;
    }
    .rewardsBar .silver {
        background-color: slategray;
        color: white;
    }
    .rewardsBar .gold {
        background-color: gold;
    }
    .rewardsBar .platinum {
        background-color: lightgray;
    }
    .rewardsBar .active {
        height: 50px;
        padding-top: 18px;
        margin-top: 0px;
    }

</style>
@endpush
@endif