<?php

namespace Hilco\Models;

use Auth;
use Illuminate\Database\Eloquent\Model;

class WebCart extends WebModel
{
    protected $table = 'WebCarts';

    public function webPart() {
        return $this->hasOne(WebPart::class, 'part_number', 'part_number');
    }

    public function priceList() {
//        return $this->hasOne(PriceList::class)
    }

    public function scopeForUser($query, $webuserId) {
        return $query->where('webuser_id', $webuserId);
    }

    public function scopePartNumber($query, $partNumber) {
        return $query->where('part_number', $partNumber);
    }

//    public function product() {
//        return $this->belongsTo(Product::class);
//    }

    public static function add(WebPart $webPart, $quantity = 1)
    {
        $instance = self::where('webuser_id',Auth::id())->where('part_number',$webPart->part_number)->first();
        if(isset($instance) && $instance->count() > 0){
            $instance->quantity = (int)$instance->quantity+(int)$quantity;
        }else{
            $instance = new static;
            $instance->webuser_id = Auth::id();
            $instance->part_number = $webPart->part_number;
            $instance->quantity = $quantity;
        }
        $instance->save();
        return $instance;
    }

    public static function remove($userId, $partNumber)
    {
        $instance = new static;
        return $instance::where(['part_number' => $partNumber, 'webuser_id' => $userId])->delete();
    }


}
