<?php

namespace Hilco\Models;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model {

	use \Hilco\SoftDeletes;

	const CREATED_AT = 'date_created';
	const UPDATED_AT = 'date_modified';

	protected $table = 'Roles';
	protected $fillable = ['role_title', 'role_slug', 'is_enabled'];

	public function users()
	{
		return $this->belongsToMany(WebUser::class, 'Role_WebUser');
	}

	public function permissions()
	{
		return $this->belongsToMany(AdminPermission::class, 'Permission_Role', 'role_id', 'permission_id');
	}
}