<?php

return [
    'emailDestinations' => [
        'orderAlert' => [
            'to' => [],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ],
        ],
        'noShippingOrderAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_HILCO_CUSTOMERSERVICE', 'hilcosupport@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ],
        ],
        'orderConfirmation' => [
            'to' => [],
            'bcc' => [],
        ],
        'newUserAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_HILCO_CUSTOMERSERVICE', 'hilcosupport@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ],
        ],
        'newUserConfirmation' => [
            'to' => [],
            'bcc' => [],
        ],
        'registrationFailedAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_HILCO_CUSTOMERSERVICE', 'hilcosupport@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ],
        ],
        'requestCorrections' => [
            'to' => [
                env('EMAIL_DESTINATION_HILCO_CUSTOMERSERVICE', 'hilcosupport@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ]
        ],
        'feedback' => [
            'to' => [
                env('EMAIL_DESTINATION_HILCO_CUSTOMERSERVICE', 'hilcosupport@visionwaresystems.com'),
            ],
            'bcc' => [
                env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ]
        ],
        'rewardsRegistrationAlert' => [
            'to' => [
                env('EMAIL_DESTINATION_HILCO_CUSTOMERSERVICE', 'hilcosupport@visionwaresystems.com'),
            ],
            'bcc' => [
                //env('EMAIL_DESTINATION_VISIONWARE_SUPPORT', 'cbarranco@visionwaresystems.com'),
            ],
        ],
    ],
    'email' => [
        'orderSubmitted' => [
            'destination' => [env('HILCO_CS_EMAIL', 'cbarranco@visionwaresystems.com')],
            'subject' => env('HILCO_ORDER_SUBMITTED_EMAIL_SUBJECT', 'Hilco B2B Order Submitted'),
        ],
    ],
    'customers' => [
        'stats' => [
            'groups' => [
                '' => 'Overall',
                'DIAGNOSTIC EXAM' => 'Diagnostic Exam',
                'REPAIR PARTS' => 'Repair Parts',
                'LAB & DISPENSING EQUIPMENT' => 'Lab & Dispensing Equipment',
                'CONSUMER ACCESSORIES' => 'Consumer Accessories',
                'PHARMACEUTICALS' => 'Pharmaceuticals',
                'SPORT/SUN PROTECTIVE EYEWEAR' => 'Sport / Sun Protective Eyewear',
                'SURGICAL' => 'Surgical',
                'LENSCARE & BRANDING' => 'Lenscare & Branding',
                'LAB SERVICES' => 'Lab Services',
                'INDUSTRIAL SAFETY EYEWEAR' => 'Industrial Safety Eyewear',
            ]
        ]
    ],
    'b2b' => [
        'url' => env('B2B_SERVER_URL')
    ],
    'uac' => [
        'url' => env('UAC_SERVER_URL')
    ],
    'assets' => [
        'url' => env('ASSET_SERVER_URL'),
        'nopic' => 'chrome/nopic',
        'tokenSalt' => 'sfed;ji365wJTEARr8y90fdhjniu',
        'sizes' => [
            'thumbnail' => [
                'width' => 80,
                'height' => 80,
            ],
            'thumbnailByHeight' => [
                'width' => -1,
                'height' => 80,
            ],
            'microByHeight' => [
                'width' => -1,
                'height' => 40,
            ],
            'small' => [
                'width' => 150,
                'height' => 150,
            ],
            'medium' => [
                'width' => 300,
                'height' => 300,
            ],
            'logo' => [
                'width' => -1,
                'height' => 45,
            ]
        ]
    ],
    'components' => [
        'bannerCarousel' => [
            'view' => 'hilco::components.bannerCarousel',
            'defaultViewData' => [
                'bannerId' => '',
                'bannerTimeout' => 3500,
                'slides' => [
                    0 => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ],
            ]
        ],
        'jumbotron' => [
            'view' => 'hilco::components.jumbotron',
            'defaultViewData' => [
                'webAssetId' => null,
                'full' => true,
            ]
        ],
        'promoTiles' => [
            'view' => 'hilco::components.promoTiles',
            'defaultViewData' => [
                'tiles' => [
                    'left' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'center' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ],
                    'right' => [
                        'webAssetId' => null,
                        'link' => [
                            'type' => null,
                            'target' => null,
                        ],
                    ]
                ]
            ]
        ],
        'children' => [
            'view' => 'hilco::components.children',
            'defaultViewData' => [
                'types' => [
                    'children' => 'All',
                    'featuredChildren' => 'Featured',
                ],
                'layouts' => [
                    'normal' => 'Normal',
                    'large' => 'Large',
                    'jumbo' => 'Jumbo',
                ],
                'type' => 'featuredChildren',
                'layout' => 'normal',
                'showNames' => true,
            ]
        ],
        'allChildren' => [
            'view' => 'hilco::components.allChildren',
            'defaultViewData' => [

            ]
        ],
        'userInfo' => [
            'view' => 'hilco::components.userInfo',
            'defaultViewData' => [

            ],
        ],
        'bestSellers' => [
            'view' => 'hilco::components.bestSellers',
            'defaultViewData' => [

            ]
        ],
        'micrositeChildren' => [
            'view' => 'hilco::components.micrositeChildren',
            'defaultViewData' => [
                'title' => 'Pre-approved Supply Items',
                'types' => [
                    'children' => 'All',
                    'featuredChildren' => 'Featured',
                ],
                'layouts' => [
                    'normal' => 'Normal',
                    'large' => 'Large',
                    'jumbo' => 'Jumbo',
                ],
                'type' => 'children',
                'layout' => 'normal',
           ],
        ],
        'productCarousel' => [
            'view' => 'hilco::components.productCarousel',
            'defaultViewData' => [
                'bannerId' => '',
                'bannerTitle' => '',
                'bannerTimeout' => 3500,
                'products' => [
                    0 => [
                        'productId' => null,
                        'productType' => null,
//                        'productWebAssetUrl' => null,
                        'productWebAssetId' => null,
                        'productTitle' => null,
                    ]
                ],
            ]
        ],
        'assetsTable' => [
            'view' => 'hilco::components.assetsTable',
            'defaultViewData' => [
                'assetsTableId' => 0,
                'webAssets' => [],
            ]
        ],
        'assetLink' => [
            'view' => 'hilco::components.assetLink',
            'defaultViewData' => [
                'webAssetId' => null,
                'link' => [
                    'type' => null,
                    'target' => null,
                    'isPrivate' => false,
                ],
                'caption' => null,
            ]
        ],
    ],
    'outOfStockLabels' => [
        'Out of Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'inStockLabels' => [
        'In Stock',
        'Custom Order',
        'Special Order',
        'Drop Ship',
    ],
    'defaultWebRoleSlug' => 'web-user',
    'jpPromoCollectionId' => env("JONATHAN_PAUL_FITOVERS_ID"),
    'jpPromoIgnoreId' => env("JONATHAN_PAUL_FITOVERS_IGNORE_ID"),
    'rateShopGroupCodes' => [
        'CA' => 2,
        'US' => 3,
    ],
    'ics' => [
        'apiEndpoint' => 'http://www1.icscourier.ca/icsapicnswebservice/service.asmx',
        'apiUsername' => '219052',
        'apiPassword' => 'GQ4XQKA66',
    ],
    'inventoryItemWebFlags' => ['A', 'I', ''],
    'divisionCountryPlants' => [
        'HILCO-US' => [
            'CA' => [
                'PLAINVILLE' => ['A', 'I', ''],
                'MONTREAL' => ['A', 'I', ''],
            ],
            '*' => [
                'PLAINVILLE' => ['A', 'I', ''],
            ]
        ],
        'WILSON-US' => [
            '*' => [
                'PLAINVILLE' => ['A', 'I', ''],
            ],
        ],
        'HILCO-UK' => [
            '*' => [
                'HAWES' => ['A', 'I', ''],
            ]
        ]
    ],
    'hilcoOutdoorWebSiloId' => env('HILCO_OUTDOOR_WEBSILO_ID'),
];
