<?php
/**
 * Created by PhpStorm.
 * User: brian
 * Date: 2/3/20
 * Time: 11:31 AM
 */

namespace Hilco\Models;


class DeliveryMethodTerm extends WebModel
{
    protected $table = "DeliveryMethod_DeliveryTerm";

    public function scopeCodes($query, $codes) {
        return $query->whereIn('delivery_method_code', $codes);
    }

    public static function delivery($method, $term, $priority){
        return DeliveryMethodTerm::where("deliverymethod_id", '=', $method)->where('deliveryterm_id', '=', $term)
            ->where('def_delivery_priority', '=', $priority)->where('deleted_at', '=', '0000-00-00 00:00:00')->first();
    }

    public function scopeByMethodTermCode ($query, $methodCode, $termCode) {
        return $query->where("delivery_method_code", "=", $methodCode)->where("delivery_term_code", "=", $termCode);
    }

    public function scopeByMethodTermId ($query, $methodId, $termId) {
        return $query->where("deliverymethod_id", "=", $methodId)->where("deliveryterm_id", "=", $termId);
    }

    public static function getMethodTermForColdShip ($coldShipRate, $coldShipOvernight = 35, $coldShipStandard = 22.5) {
        if (is_numeric($coldShipRate)) {
            if ($coldShipRate == $coldShipOvernight) {
                return self::byMethodTermCode(DeliveryMethod::UPS_NEXT_DAY_AIR, DeliveryTerm::FLAT_RATE_OVERNIGHT)->first();
            } else if ($coldShipRate == $coldShipStandard) {
                return self::byMethodTermCode(DeliveryMethod::UPS_2ND_DAY, DeliveryTerm::FLAT_RATE_2ND_DAY)->first();
            } else if ($coldShipRate == 0) {
                return self::byMethodTermCode(DeliveryMethod::UPS_2ND_DAY, DeliveryTerm::FREE_COLD_PHARM)->first();
            }
        }
        return null;
    }
}